"use strict";
exports.id = 69;
exports.ids = [69];
exports.modules = {

/***/ 84406:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/Apple Logo.03c5ec4c.svg","height":20,"width":20});

/***/ }),

/***/ 57008:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/Facebook.ad91c1d4.png","height":50,"width":51,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA+ElEQVR42mOAAcFlvwuVV/y5xLD0z3WGxb/bcs/8Z4ZLCsz90S0z/8d/hlk//lss+fHfZunP/wxzfqwDS/JP/qKnOO3Lf4auz//btn378+3Xv7/LTvz4zdD9+b/1zC+hDHydH5JUez78Z6h89+fEzZ//bz759Z+h4f0fhe73/wU73/cw2HS88WQoevW/f/OnXz///Pv/8/e//9N3fPrJUPzqv1HrmyKwNaKlz88w5D37f+7Wtz/X73//w5D77D9Q7JVB7QthsIKSqS9kGDTu7Tty4fP/c9e+/Gcwun8xsvWZEVhSuugp3Duv3/+Kef3uVwqML1n0lBkAXPWHlPjWYbIAAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 69473:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/Google_Logo.7409186b.png","height":24,"width":25,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA7UlEQVR42jWOTysEcRyHvxfvxEvwDrwDSlJK7X0vIuWwSlFKm1pTLpSDi2jX+NNeFtnaKFFS1DflJLtW2jUzZn4z30dM+9SnPofn8Aigljq+z47tozDF3/q1Q8vCEEDFkky/vE3eROxzdZluaZH3kWFz7XYuuKcT7YwKwVXT+Mcg6g++irspaHoxDmBBDJ4fUa7GVqmGnN8nKrRmtNccy4UIlvYC5rYDk/keFT9S6b7WdXpXaLxcG+TcaWJDCyG3z4lKbGi5tYNsiZUa66xcriEbs+addvJIQNPMcfRYt0m/yEStyP7Dgf2kAYD+Ak180asSZcPNAAAAAElFTkSuQmCC","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 84379:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "R": () => (/* binding */ ProfileApi)
/* harmony export */ });
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61176);
/* harmony import */ var _helper_functions_getToken__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61859);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_0__]);
_MainApi__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const ProfileApi = {
    profileInfo: ()=>{
        const token = (0,_helper_functions_getToken__WEBPACK_IMPORTED_MODULE_1__/* .getToken */ .L)();
        return token && _MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"].get */ .Z.get("/api/v1/customer/info");
    },
    profileUpdate: (profileData)=>_MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"].post */ .Z.post("/api/v1/customer/update-profile", profileData)
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 40657:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "H": () => (/* binding */ usePostRegisterInfo)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const postHandler = async (info)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].post */ .Z.post(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .social_register_api */ .kw}`, info);
    return data;
};
const usePostRegisterInfo = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)("info_post_request", postHandler);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 96875:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ useSignIn)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const userSignIn = async (signInData)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].post */ .Z.post(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .signIn_api */ .JF}`, signInData);
    return data;
};
const useSignIn = (handleError)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)("sign-In", userSignIn, {
        onError: handleError
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 35432:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q": () => (/* binding */ useSignUp)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const userSignUp = async (signUpData)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].post */ .Z.post(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .signUp_api */ .h6}`, signUpData);
    return data;
};
const useSignUp = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)("sign-up", userSignUp);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6025:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "D": () => (/* binding */ useUpdateUserInfo)
/* harmony export */ });
/* harmony import */ var api_manage_MainApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61176);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([api_manage_MainApi__WEBPACK_IMPORTED_MODULE_0__]);
api_manage_MainApi__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const postHandler = async (userData)=>{
    const { data  } = await api_manage_MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"].post */ .Z.post("/api/v1/auth/update-info", userData);
    return data;
};
const useUpdateUserInfo = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)("update_user", postHandler);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54675:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ useVerifyPhone)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const sendOtp = async (otpData)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].post */ .Z.post(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .verify_phone_api */ .ig}`, otpData);
    return data;
};
const useVerifyPhone = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)("verify_phone_otp", sendOtp);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 83291:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useGetProfile)
/* harmony export */ });
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61176);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60274);
/* harmony import */ var _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67759);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_0__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__]);
([_MainApi__WEBPACK_IMPORTED_MODULE_0__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const getUserProfile = async ()=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"].get */ .Z.get(_ApiRoutes__WEBPACK_IMPORTED_MODULE_3__/* .profile_info */ .RO);
    return data;
};
function useGetProfile(userOnSuccessHandler) {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)("user-profile", getUserProfile, {
        enabled: false,
        onSuccess: userOnSuccessHandler,
        onError: _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__/* .onErrorResponse */ .RJ
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 93749:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ useGetWishList)
/* harmony export */ });
/* unused harmony export WishList */
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
/* harmony import */ var api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const WishList = async ()=>{
    const { data  } = await api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].get */ .Z.get(`${api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .wishlist_api */ .pv}`);
    return data;
};
const useGetWishList = (onSuccessHandler)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)("get-rental-wishlist", ()=>WishList(), {
        enabled: false,
        retry: false,
        onSuccess: onSuccessHandler
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 32399:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "v": () => (/* binding */ usePostEmail)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const postHandler = async (email)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].post */ .Z.post(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .social_login_api */ .sL}`, email);
    return data;
};
const usePostEmail = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)("email_post_request", postHandler);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10550:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "F": () => (/* binding */ useWishListGet)
/* harmony export */ });
/* unused harmony export WishList */
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__]);
_MainApi__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const WishList = async ()=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].get */ .Z.get(`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .get_wish_list_api */ .RY}`);
    return data;
};
const useWishListGet = (onSuccessHandler)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)("wishlist", ()=>WishList(), {
        enabled: false,
        retry: false,
        onSuccess: onSuccessHandler
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44657:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22021);
/* harmony import */ var _landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77591);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_4__]);
i18next__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const AcceptTermsAndConditions = ({ handleCheckbox , formikType , handleClick  })=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.useTheme)();
    const descriptionId = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
    const id2 = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                direction: "row",
                alignItems: "center",
                spacing: {
                    xs: "0",
                    md: ".5"
                },
                sx: {
                    mt: "-10px"
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, {
                        sx: {
                            marginRight: "5px",
                            "& .MuiFormControlLabel-label": {
                                fontSize: "14px",
                                color: (theme)=>theme.palette.neutral[1000]
                            },
                            [theme.breakpoints.down("sm")]: {
                                "& .MuiFormControlLabel-label": {
                                    fontSize: "12px"
                                }
                            }
                        },
                        control: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, {
                            id: descriptionId,
                            value: "ff",
                            color: "primary",
                            onChange: handleCheckbox,
                            required: "true"
                        }),
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_4__.t)("You must accept the")
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                        id: id2,
                        children: [
                            (0,i18next__WEBPACK_IMPORTED_MODULE_4__.t)("You must accept the"),
                            " ",
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                onClick: handleClick,
                                style: {
                                    color: theme.palette.primary.main,
                                    cursor: "pointer",
                                    textDecoration: "underline"
                                },
                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_4__.t)("terms and conditions")
                            })
                        ]
                    })
                ]
            }),
            formikType.touched.tandc && formikType.errors.tandc && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomTypography */ .ZT, {
                variant: "caption",
                sx: {
                    fontWeight: "inherit",
                    color: (theme)=>theme.palette.error.main
                },
                children: (0,i18next__WEBPACK_IMPORTED_MODULE_4__.t)("You must accept the terms and conditions")
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AcceptTermsAndConditions);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 37092:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export CustomSignUpTextField */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22021);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33103);
/* harmony import */ var _mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9026);
/* harmony import */ var _mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1883);
/* harmony import */ var _mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(27549);
/* harmony import */ var _mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(86072);
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_mui_lab__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(45269);
/* harmony import */ var components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(58861);
/* harmony import */ var components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(65304);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(61859);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(46573);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_3__, components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_13__]);
([i18next__WEBPACK_IMPORTED_MODULE_3__, components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const CustomSignUpTextField = (0,_mui_system__WEBPACK_IMPORTED_MODULE_15__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.TextField)(({ theme  })=>({
        "& .MuiInputBase-input": {
            padding: "12.5px 0px !important",
            fontSize: "14px",
            fontWeight: "400",
            borderRadius: "4px",
            "&::placeholder": {
                color: (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[400], 0.7)
            }
        },
        "& .MuiOutlinedInput-root": {
            borderRadius: "4px",
            "& fieldset": {
                borderColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[400], 0.5),
                borderWidth: "1px"
            },
            "&:hover fieldset": {
                borderColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[600], 0.7)
            },
            "&.Mui-focused fieldset": {
                borderColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.primary.main, 0.7),
                borderWidth: "1px"
            }
        },
        "& .MuiInputLabel-root": {
            color: theme.palette.neutral[1000],
            "&.Mui-focused": {
                color: (theme)=>theme.palette.neutral[1000]
            },
            "&.MuiInputLabel-shrink": {
                transform: "translate(14px, -6px) scale(0.75) !important"
            }
        }
    }));
const AddUserInfo = ({ formSubmitHandler , loginInfo , isLoading , userInfo  })=>{
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_14__.useSelector)((state)=>state.configData);
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_16__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_16__/* .getLanguage */ .G)() : "ltr";
    const userInfoFormik = (0,formik__WEBPACK_IMPORTED_MODULE_4__.useFormik)({
        initialValues: {
            name: userInfo?.name ? userInfo?.name : "",
            email: "",
            ref_code: "",
            phone: ""
        },
        validationSchema: yup__WEBPACK_IMPORTED_MODULE_5__.object({
        }),
        onSubmit: async (values, helpers)=>{
            try {
                formSubmitHandler({
                    ...values,
                    login_type: loginInfo.login_type,
                    phone: loginInfo?.is_email ? values?.phone : loginInfo.phone,
                    email: loginInfo?.is_email ? loginInfo?.email : values?.email,
                    guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_17__/* .getGuestId */ .P)()
                });
            } catch (err) {}
        }
    });
    const otpHandleChange = (value)=>{
        userInfoFormik.setFieldValue("phone", `+${value}`);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__/* .CustomStackFullWidth */ .Xw, {
            spacing: 3,
            sx: {
                maxWidth: "400px",
                padding: "2rem"
            },
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__/* .CustomStackFullWidth */ .Xw, {
                    alignItems: "center",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                        src: configData?.logo_full_url,
                        maxWidth: "300px",
                        height: "50px",
                        alt: "Logo",
                        objectfit: "contain"
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    textAlign: "center",
                    fontSize: "14px",
                    color: "textSecondary",
                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Just one step away! This will help make your profile more personalized.")
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__/* .CustomStackFullWidth */ .Xw, {
                    alignItems: "center",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
                        onSubmit: userInfoFormik.handleSubmit,
                        noValidate: true,
                        style: {
                            width: "100%"
                        },
                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__/* .CustomStackFullWidth */ .Xw, {
                            gap: "36px",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSignUpTextField, {
                                    required: true,
                                    fullWidth: true,
                                    id: "name",
                                    label: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Name"),
                                    placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Name"),
                                    name: "name",
                                    autoComplete: "name",
                                    value: userInfoFormik.values.name,
                                    onChange: userInfoFormik.handleChange,
                                    error: userInfoFormik.touched.name && Boolean(userInfoFormik.errors.name),
                                    helperText: userInfoFormik.touched.name && userInfoFormik.errors.name,
                                    touched: userInfoFormik.touched.name,
                                    InputProps: {
                                        startAdornment: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6___default()), {
                                            position: "start",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_8___default()), {
                                                sx: {
                                                    fontSize: "1.2rem",
                                                    color: (theme)=>(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[400], 0.5)
                                                }
                                            })
                                        })
                                    }
                                }),
                                loginInfo?.is_email ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                                    value: userInfoFormik.values.phone,
                                    onHandleChange: otpHandleChange,
                                    initCountry: configData?.country,
                                    touched: userInfoFormik.touched.phone,
                                    errors: userInfoFormik.errors.phone,
                                    rtlChange: "true",
                                    lanDirection: lanDirection,
                                    height: "45px"
                                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSignUpTextField, {
                                    required: true,
                                    fullWidth: true,
                                    id: "email",
                                    label: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Email"),
                                    name: "email",
                                    autoComplete: "email",
                                    placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Email"),
                                    value: userInfoFormik.values.email,
                                    onChange: userInfoFormik.handleChange,
                                    error: userInfoFormik.touched.email && Boolean(userInfoFormik.errors.email),
                                    helperText: userInfoFormik.touched.email && userInfoFormik.errors.email,
                                    touched: userInfoFormik.touched.email,
                                    InputProps: {
                                        startAdornment: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6___default()), {
                                            position: "start",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_7___default()), {
                                                sx: {
                                                    fontSize: "1.2rem",
                                                    color: (theme)=>(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[400], 0.5)
                                                }
                                            })
                                        })
                                    }
                                }),
                                configData?.customer_wallet_status === 1 && configData?.ref_earning_status === 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSignUpTextField, {
                                    fullWidth: true,
                                    id: "ref_code",
                                    label: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Refer Code (Optional)"),
                                    placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Refer Code (Optional)"),
                                    name: "ref_code",
                                    autoComplete: "ref_code",
                                    value: userInfoFormik.values.ref_code,
                                    onChange: userInfoFormik.handleChange,
                                    error: userInfoFormik.touched.ref_code && Boolean(userInfoFormik.errors.ref_code),
                                    helperText: userInfoFormik.touched.ref_code && userInfoFormik.errors.ref_code,
                                    touched: userInfoFormik.touched.ref_code,
                                    //   autoFocus
                                    InputProps: {
                                        startAdornment: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_6___default()), {
                                            position: "start",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_9___default()), {
                                                sx: {
                                                    fontSize: "1.2rem",
                                                    color: (theme)=>(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[400], 0.5)
                                                }
                                            })
                                        })
                                    }
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_lab__WEBPACK_IMPORTED_MODULE_10__.LoadingButton, {
                                    type: "submit",
                                    fullWidth: true,
                                    sx: {
                                        mt: 1,
                                        mb: 3.5,
                                        maxWidth: "400px",
                                        height: "45px"
                                    },
                                    loading: isLoading,
                                    variant: "contained",
                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Done")
                                })
                            ]
                        })
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(AddUserInfo));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4561:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58861);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45269);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(81261);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_7__]);
utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_7__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const AuthHeader = ({ title , configData  })=>{
    const businessLogo = configData?.base_urls?.business_logo_url;
    let zoneid = undefined;
    if (false) {}
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const handleLogoClick = ()=>{
        if (router.pathname.includes("/auth")) {
            router.push("/home", undefined, {
                shallow: true
            });
        }
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
        justifyContent: "center",
        alignItems: "center",
        spacing: 2,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Box, {
                onClick: handleLogoClick,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    maxWidth: "300px",
                    height: "50px",
                    objectfit: "cover",
                    src: configData?.logo_full_url
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                fontSize: "18px",
                fontWeight: "600",
                textAlign: "left",
                textTransform: "uppercase",
                children: title
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AuthHeader);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 40069:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "setUpRecaptcha": () => (/* binding */ setUpRecaptcha)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86390);
/* harmony import */ var components_auth_sign_in__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35080);
/* harmony import */ var components_auth_sign_up_SignUp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8218);
/* harmony import */ var components_auth_AddUserInfo__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37092);
/* harmony import */ var components_auth_ExitingUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(38091);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(69484);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var api_manage_hooks_react_query_auth_useSignIn__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(96875);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(67759);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(61859);
/* harmony import */ var firebase_auth__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(60401);
/* harmony import */ var api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(10550);
/* harmony import */ var utils_toasterMessages__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(70557);
/* harmony import */ var redux_slices_wishList__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(64134);
/* harmony import */ var api_manage_hooks_react_query_auth_useUpdateUserInfo__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(6025);
/* harmony import */ var api_manage_another_formated_api_profileApi__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(84379);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(65337);
/* harmony import */ var firebase__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(29901);
/* harmony import */ var components_auth_sign_in_social_login_PhoneInputForm__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(20746);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(86201);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(22021);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(90603);
/* harmony import */ var api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(93749);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([components_auth_sign_in__WEBPACK_IMPORTED_MODULE_4__, components_auth_sign_up_SignUp__WEBPACK_IMPORTED_MODULE_5__, components_auth_AddUserInfo__WEBPACK_IMPORTED_MODULE_6__, components_auth_ExitingUser__WEBPACK_IMPORTED_MODULE_7__, api_manage_hooks_react_query_auth_useSignIn__WEBPACK_IMPORTED_MODULE_9__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__, firebase_auth__WEBPACK_IMPORTED_MODULE_11__, api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_12__, api_manage_hooks_react_query_auth_useUpdateUserInfo__WEBPACK_IMPORTED_MODULE_14__, api_manage_another_formated_api_profileApi__WEBPACK_IMPORTED_MODULE_15__, firebase__WEBPACK_IMPORTED_MODULE_18__, components_auth_sign_in_social_login_PhoneInputForm__WEBPACK_IMPORTED_MODULE_19__, react_hot_toast__WEBPACK_IMPORTED_MODULE_20__, i18next__WEBPACK_IMPORTED_MODULE_21__, api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_22__]);
([components_auth_sign_in__WEBPACK_IMPORTED_MODULE_4__, components_auth_sign_up_SignUp__WEBPACK_IMPORTED_MODULE_5__, components_auth_AddUserInfo__WEBPACK_IMPORTED_MODULE_6__, components_auth_ExitingUser__WEBPACK_IMPORTED_MODULE_7__, api_manage_hooks_react_query_auth_useSignIn__WEBPACK_IMPORTED_MODULE_9__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__, firebase_auth__WEBPACK_IMPORTED_MODULE_11__, api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_12__, api_manage_hooks_react_query_auth_useUpdateUserInfo__WEBPACK_IMPORTED_MODULE_14__, api_manage_another_formated_api_profileApi__WEBPACK_IMPORTED_MODULE_15__, firebase__WEBPACK_IMPORTED_MODULE_18__, components_auth_sign_in_social_login_PhoneInputForm__WEBPACK_IMPORTED_MODULE_19__, react_hot_toast__WEBPACK_IMPORTED_MODULE_20__, i18next__WEBPACK_IMPORTED_MODULE_21__, api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_22__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


























const setUpRecaptcha = ()=>{
    if (document.getElementById("recaptcha-container")) {
        if (!window.recaptchaVerifier) {
            window.recaptchaVerifier = new firebase_auth__WEBPACK_IMPORTED_MODULE_11__.RecaptchaVerifier("recaptcha-container", {
                size: "invisible",
                callback: (response)=>{
                    console.log("Recaptcha verified", response);
                },
                "expired-callback": ()=>{
                    window.recaptchaVerifier?.reset();
                }
            }, firebase__WEBPACK_IMPORTED_MODULE_18__/* .auth */ .I8);
        } else {
            window.recaptchaVerifier.clear();
            window.recaptchaVerifier = null;
        }
    }
};
const AuthModal = ({ modalFor , open , handleClose , setModalFor  })=>{
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)((state)=>state.configData);
    const [loginInfo, setLoginInfo] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [userInfo, setUserInfo] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const theme = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_8__.useTheme)();
    const { userInfo: fbUserInfo , jwtToken: fbJwtToken  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)((state)=>state.fbCredentialsStore);
    const [jwtToken, setJwtToken] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [medium, setMedium] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const [verificationId, setVerificationId] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const user = medium === "google" ? userInfo : fbUserInfo;
    const jwt = medium === "google" ? jwtToken : fbJwtToken;
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useDispatch)();
    const recaptchaWrapperRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { mutate , isLoading  } = (0,api_manage_hooks_react_query_auth_useUpdateUserInfo__WEBPACK_IMPORTED_MODULE_14__/* .useUpdateUserInfo */ .D)();
    const { mutate: loginMutation , isLoading: loginIsLoading  } = (0,api_manage_hooks_react_query_auth_useSignIn__WEBPACK_IMPORTED_MODULE_9__/* .useSignIn */ .z)();
    const userOnSuccessHandler = (res)=>{
        dispatch((0,redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_17__/* .setUser */ .av)(res?.data));
    };
    const { refetch: profileRefatch  } = (0,react_query__WEBPACK_IMPORTED_MODULE_16__.useQuery)([
        "profile-info"
    ], api_manage_another_formated_api_profileApi__WEBPACK_IMPORTED_MODULE_15__/* .ProfileApi.profileInfo */ .R.profileInfo, {
        enabled: false,
        onSuccess: userOnSuccessHandler,
        onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__/* .onSingleErrorResponse */ .f$
    });
    let zoneid = undefined;
    const moduleType = (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_23__/* .getCurrentModuleType */ .X)();
    if (false) {}
    const onSuccessHandler = (res)=>{
        dispatch((0,redux_slices_wishList__WEBPACK_IMPORTED_MODULE_13__/* .setWishList */ .Q5)(res));
    };
    const { refetch  } = (0,api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_12__/* .useWishListGet */ .F)(onSuccessHandler);
    const { refetch: rentalWishlistRefetch  } = (0,api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_22__/* .useGetWishList */ .z)(onSuccessHandler);
    const handleSuccess = async (value)=>{
        localStorage.setItem("token", value);
        react_hot_toast__WEBPACK_IMPORTED_MODULE_20__.toast.success((0,i18next__WEBPACK_IMPORTED_MODULE_21__.t)(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_24__/* .loginSuccessFull */ .cu));
        if (zoneid) {
            if (moduleType === "rental") {
                await rentalWishlistRefetch();
            } else {
                await refetch();
            }
        }
        await profileRefatch();
        handleClose?.();
    };
    const handleRegistrationOnSuccess = (token)=>{
        handleSuccess(token).then();
        handleClose();
    };
    const handleUpdateUserInfo = (values)=>{
        mutate(values, {
            onSuccess: (res)=>{
                handleSuccess(res?.token);
            },
            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__/* .onErrorResponse */ .RJ
        });
    };
    const handleSubmitExistingUser = (value)=>{
        let tempValues = {};
        if (loginInfo?.is_email) {
            tempValues = {
                verified: value,
                login_type: loginInfo?.login_type,
                email: userInfo?.email,
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_25__/* .getGuestId */ .P)(),
                token: jwtToken?.credential,
                unique_id: jwtToken?.clientId,
                medium: medium
            };
        } else {
            tempValues = {
                verified: value,
                login_type: loginInfo?.login_type,
                phone: loginInfo?.phone,
                otp: loginInfo?.otp,
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_25__/* .getGuestId */ .P)()
            };
        }
        loginMutation(tempValues, {
            onSuccess: (res)=>{
                if (res?.is_personal_info === 0) {
                    setModalFor("user_info");
                } else {
                    handleSuccess(res?.token);
                }
            },
            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_10__/* .onErrorResponse */ .RJ
        });
    };
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        setUpRecaptcha();
        return ()=>{
            if (recaptchaWrapperRef.current) {
                recaptchaWrapperRef.current.clear(); // Clear Recaptcha when component unmounts
                recaptchaWrapperRef.current = null;
            }
        };
    }, []);
    const sendOTP = (response, setOtpData, setMainToken, phone)=>{
        const phoneNumber = phone;
        if (!phoneNumber) {
            console.error("Invalid phone number");
            return;
        }
        if (!window.recaptchaVerifier) {
            setUpRecaptcha();
        }
        // country code
        const appVerifier = window.recaptchaVerifier;
        (0,firebase_auth__WEBPACK_IMPORTED_MODULE_11__.signInWithPhoneNumber)(firebase__WEBPACK_IMPORTED_MODULE_18__/* .auth */ .I8, phoneNumber, appVerifier).then((confirmationResult)=>{
            setVerificationId(confirmationResult.verificationId);
            setOtpData({
                type: phone
            });
            setMainToken(response);
        }).catch((error)=>{
            console.log("Error in sending OTP", error);
        });
    };
    const renderModalContent = ()=>{
        switch(modalFor){
            case "sign-in":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                    handleClose: handleClose,
                    configData: configData,
                    setModalFor: setModalFor,
                    setJwtToken: setJwtToken,
                    setUserInfo: setUserInfo,
                    handleSuccess: handleSuccess,
                    setMedium: setMedium,
                    zoneid: zoneid,
                    setLoginInfo: setLoginInfo,
                    loginMutation: loginMutation,
                    loginIsLoading: loginIsLoading,
                    verificationId: verificationId,
                    sendOTP: sendOTP,
                    modalFor: modalFor
                });
            case "phone_modal":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: user && jwt?.clientId && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_social_login_PhoneInputForm__WEBPACK_IMPORTED_MODULE_19__/* ["default"] */ .Z, {
                        userInfo: user,
                        jwtToken: jwt,
                        configData: configData,
                        medium: medium,
                        handleRegistrationOnSuccess: handleRegistrationOnSuccess,
                        setModalFor: setModalFor
                    })
                });
            case "user_info":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_AddUserInfo__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                    formSubmitHandler: handleUpdateUserInfo,
                    loginInfo: loginInfo,
                    isLoading: isLoading,
                    userInfo: userInfo
                });
            case "is_exist_user":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_ExitingUser__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                    loginInfo: loginInfo,
                    formSubmitHandler: handleSubmitExistingUser,
                    isLoading: isLoading,
                    setModalFor: setModalFor,
                    userInfo: user,
                    jwtToken: jwt,
                    medium: medium,
                    loginIsLoading: loginIsLoading
                }); // Replace with ExitingUser component
            default:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_up_SignUp__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    configData: configData,
                    setModalFor: setModalFor,
                    verificationId: verificationId,
                    sendOTP: sendOTP,
                    handleClose: handleClose,
                    loginMutation: loginMutation
                });
        }
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_modal__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        handleClose: handleClose,
        openModal: open,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                ref: recaptchaWrapperRef,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    id: "recaptcha-container"
                })
            }),
            renderModalContent()
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AuthModal);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 38091:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(47915);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22021);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(45269);
/* harmony import */ var styled_components_CustomButtons_style__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(81029);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_5__]);
i18next__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const ExitingUser = ({ setModalFor , formSubmitHandler , userInfo , loginIsLoading , loginInfo  })=>{
    const [isYes, setIsYes] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.useTheme)();
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state.configData);
    const postNewUser = (value)=>{
        setIsYes(value);
        formSubmitHandler(value);
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__/* .CustomStackFullWidth */ .Xw, {
        spacing: 3,
        sx: {
            maxWidth: "400px",
            padding: "2rem"
        },
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__/* .CustomStackFullWidth */ .Xw, {
                alignItems: "center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Avatar, {
                        src: `${loginInfo?.is_exist_user?.image}/${configData?.base_urls?.customer_image_url}`
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                        fontSize: "14px",
                        children: loginInfo?.is_exist_user?.name
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__/* .CustomStackFullWidth */ .Xw, {
                alignItems: "center",
                spacing: 1,
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Is It You?")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                        textAlign: "center",
                        fontSize: "14px",
                        color: theme.palette.text.secondary,
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("It looks like the email you entered has already been used and has an existing account.")
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                direction: "row",
                alignItems: "center",
                justifyContent: "center",
                width: "100%",
                spacing: {
                    xs: 1,
                    sm: 2,
                    md: 3
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomButtons_style__WEBPACK_IMPORTED_MODULE_8__/* .CustomButtonCancel */ .tZ, {
                        variant: "contained",
                        onClick: ()=>postNewUser("no"),
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("No")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomButtons_style__WEBPACK_IMPORTED_MODULE_8__/* .CustomButtonSuccess */ .p1, {
                        loading: isYes === "yes" && loginIsLoading,
                        variant: "contained",
                        onClick: ()=>postNewUser("yes"),
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Yes")
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ExitingUser));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 73666:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const PhoneOrEmailIcon = ()=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
            xmlns: "http://www.w3.org/2000/svg",
            width: "18",
            height: "18",
            viewBox: "0 0 18 18",
            fill: "none",
            children: [
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                    "clip-path": "url(#clip0_6975_79560)",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                            d: "M12.6248 5.83388C13.0152 5.83388 13.3977 5.72418 13.7287 5.51729L18.0007 2.84731C18.0007 2.51741 17.7332 2.25 17.4033 2.25H7.84634C7.51647 2.25 7.24902 2.51741 7.24902 2.84731L11.521 5.51729C11.852 5.72418 12.2345 5.83388 12.6248 5.83388Z",
                            fill: "#CBD0D4"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                            d: "M12.6248 6.4309C12.2345 6.4309 11.852 6.3212 11.521 6.11431L7.24902 3.44434V8.22284C7.24902 8.88261 7.78389 9.41747 8.44365 9.41747H16.806C17.4658 9.41747 18.0007 8.88261 18.0007 8.22284V3.44434L13.7287 6.11431C13.3977 6.3212 13.0152 6.4309 12.6248 6.4309Z",
                            fill: "#CBD0D4"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                            d: "M10.1543 11.6479C9.1698 11.6479 8.32549 12.244 7.95968 13.0945C5.76722 12.3896 4.03679 10.6591 3.33192 8.46671C4.18236 8.10086 4.77851 7.25655 4.77851 6.27206C4.77851 4.9525 3.70882 3.88281 2.38925 3.88281C1.06969 3.88281 0 4.9525 0 6.27206C0 11.8802 4.54624 16.4264 10.1543 16.4264C11.4739 16.4264 12.5436 15.3567 12.5436 14.0371C12.5436 12.7176 11.4739 11.6479 10.1543 11.6479Z",
                            fill: "#CBD0D4"
                        })
                    ]
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("defs", {
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("clipPath", {
                        id: "clip0_6975_79560",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("rect", {
                            width: "18",
                            height: "18",
                            fill: "white"
                        })
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PhoneOrEmailIcon);


/***/ }),

/***/ 59856:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(76829);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22021);
/* harmony import */ var _mui_material_Typography__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27163);
/* harmony import */ var _mui_material_Typography__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material_Typography__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45269);
/* harmony import */ var components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65304);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(46573);
/* harmony import */ var redux_slices_configData__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(53236);
/* harmony import */ var components_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(77591);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_3__, components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_6__]);
([i18next__WEBPACK_IMPORTED_MODULE_3__, components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const OtpLogin = ({ otpLoginFormik , otpHandleChange , global , isLoading , handleClick , rememberMeHandleChange , fireBaseId , configData  })=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.useTheme)();
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__/* .getLanguage */ .G)() : "ltr";
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_Typography__WEBPACK_IMPORTED_MODULE_4___default()), {
                fontSize: "18px",
                fontWeight: "600",
                textAlign: "left",
                mb: "1rem",
                children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Sign In")
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
                onSubmit: otpLoginFormik.handleSubmit,
                noValidate: true,
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
                    sx: {
                        gap: "14px"
                    },
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            value: otpLoginFormik.values.phone,
                            onHandleChange: otpHandleChange,
                            initCountry: configData?.country,
                            touched: otpLoginFormik.touched.phone,
                            errors: otpLoginFormik.errors.phone,
                            rtlChange: "true",
                            borderRadius: "10px",
                            height: "45px",
                            lanDirection: lanDirection
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.FormControlLabel, {
                            control: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Checkbox, {
                                value: "remember",
                                color: "primary",
                                onChange: rememberMeHandleChange
                            }),
                            label: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_9__/* .CustomTypography */ .ZT, {
                                fontSize: "14px",
                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Remember me")
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
                            sx: {
                                paddingBottom: "5px"
                            },
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomColouredTypography */ .i5, {
                                onClick: handleClick,
                                sx: {
                                    cursor: "pointer",
                                    // textDecoration: 'underline',
                                    fontWeight: "400",
                                    fontSize: "12px",
                                    [theme.breakpoints.down("sm")]: {
                                        fontSize: "12px",
                                        marginLeft: "0px"
                                    }
                                },
                                children: [
                                    (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("* By login I Agree with all the"),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_Typography__WEBPACK_IMPORTED_MODULE_4___default()), {
                                        component: "span",
                                        color: theme.palette.primary.main,
                                        sx: {
                                            textAlign: "center",
                                            fontWeight: "400",
                                            fontSize: "12px"
                                        },
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)(" Terms & Conditions")
                                    })
                                ]
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_2___default()), {
                            type: "submit",
                            fullWidth: true,
                            variant: "contained",
                            sx: {
                                fontSize: "14px",
                                fontWeight: "500",
                                height: "45px"
                            },
                            loading: isLoading,
                            id: fireBaseId,
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Get OTP ")
                        })
                    ]
                })
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OtpLogin);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 72823:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65304);
/* harmony import */ var _form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42492);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22021);
/* harmony import */ var _helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(46573);
/* harmony import */ var _mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12906);
/* harmony import */ var _mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var components_custom_component_CustomPhoneInputManual__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(40869);
/* harmony import */ var utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(81261);
/* harmony import */ var components_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77591);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(76829);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var components_auth_asset_PhoneOrEmailIcon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(73666);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_3__, i18next__WEBPACK_IMPORTED_MODULE_5__, components_custom_component_CustomPhoneInputManual__WEBPACK_IMPORTED_MODULE_8__, utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_9__]);
([_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_3__, i18next__WEBPACK_IMPORTED_MODULE_5__, components_custom_component_CustomPhoneInputManual__WEBPACK_IMPORTED_MODULE_8__, utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const SignInForm = ({ loginFormik , configData , handleOnChange , passwordHandler , rememberMeHandleChange , isApiCalling , isLoading , handleSignUp , only , handleClick  })=>{
    const lanDirection = (0,_helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_13__/* .getLanguage */ .G)() ? (0,_helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_13__/* .getLanguage */ .G)() : "ltr";
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.useTheme)();
    const textColor = theme.palette.whiteContainer.main;
    const [isPhone, setIsPhone] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        const value = loginFormik.values.email_or_phone;
        const filterInput = (0,utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_9__/* .checkInput */ .lj)(value);
        if (filterInput === "phone") {
            setIsPhone("phone");
        } else {
            setIsPhone("email");
        }
    }, [
        loginFormik.values.email_or_phone
    ]);
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
        noValidate: true,
        onSubmit: loginFormik.handleSubmit,
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
            alignItems: "center",
            children: [
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                    spacing: {
                        xs: 2,
                        md: 3
                    },
                    sx: {
                        position: "relative"
                    },
                    children: [
                        isPhone === "phone" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_custom_component_CustomPhoneInputManual__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                            value: loginFormik.values.email_or_phone,
                            onHandleChange: handleOnChange,
                            initCountry: configData?.country,
                            touched: loginFormik.touched.email_or_phone,
                            errors: loginFormik.errors.email_or_phone,
                            lanDirection: lanDirection,
                            height: "45px",
                            autoFocus: true,
                            borderRadius: "10px"
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            autoFocus: isPhone === "email" && true,
                            required: true,
                            label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Email/Phone"),
                            placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Email/Phone"),
                            touched: loginFormik.touched.email_or_phone,
                            errors: loginFormik.errors.email_or_phone,
                            fieldProps: loginFormik.getFieldProps("email_or_phone"),
                            onChangeHandler: handleOnChange,
                            value: loginFormik.values.email_or_phone,
                            startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.InputAdornment, {
                                position: "start",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_asset_PhoneOrEmailIcon__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                                    sx: {
                                        color: loginFormik.touched.email_or_phone && !loginFormik.errors.email_or_phone ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.alpha)(theme.palette.neutral[500], 0.4)
                                    }
                                })
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            height: "45px",
                            required: "true",
                            type: "password",
                            label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Password"),
                            placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Enter password"),
                            touched: loginFormik.touched.password,
                            errors: loginFormik.errors.password,
                            fieldProps: loginFormik.getFieldProps("password"),
                            onChangeHandler: passwordHandler,
                            value: loginFormik.values.password,
                            startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.InputAdornment, {
                                position: "start",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_6___default()), {
                                    sx: {
                                        color: loginFormik.touched.password && !loginFormik.errors.password ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.alpha)(theme.palette.neutral[500], 0.6)
                                    }
                                })
                            })
                        })
                    ]
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                    mt: "10px",
                    spacing: 2,
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                            justifyContent: "space-between",
                            alignItems: "center",
                            direction: "row",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.FormControlLabel, {
                                    control: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Checkbox, {
                                        value: "remember",
                                        color: "primary",
                                        onChange: rememberMeHandleChange
                                    }),
                                    label: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__/* .CustomTypography */ .ZT, {
                                        fontSize: "14px",
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Remember me")
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomLink */ .xb, {
                                    href: "/forgot-password",
                                    sx: {
                                        fontWeight: "400",
                                        fontSize: "14px"
                                    },
                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Forgot password?")
                                })
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                            sx: {
                                paddingBottom: "5px"
                            },
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomColouredTypography */ .i5, {
                                onClick: handleClick,
                                sx: {
                                    cursor: "pointer",
                                    // textDecoration: 'underline',
                                    fontWeight: "400",
                                    fontSize: "12px",
                                    [theme.breakpoints.down("sm")]: {
                                        fontSize: "12px",
                                        marginLeft: "0px"
                                    }
                                },
                                children: [
                                    (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("* By login I Agree with all the"),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Typography, {
                                        component: "span",
                                        color: theme.palette.primary.main,
                                        sx: {
                                            textAlign: "center",
                                            fontWeight: "400",
                                            fontSize: "12px"
                                        },
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)(" Terms & Conditions")
                                    })
                                ]
                            })
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                            spacing: 2,
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_11___default()), {
                                    type: "submit",
                                    fullWidth: true,
                                    variant: "contained",
                                    loading: isLoading,
                                    sx: {
                                        color: textColor
                                    },
                                    id: "recaptcha-container",
                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign In")
                                }),
                                only && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                                    alignItems: "center",
                                    spacing: 0.5,
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                                        direction: "row",
                                        alignItems: "center",
                                        justifyContent: "center",
                                        spacing: 0.5,
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__/* .CustomTypography */ .ZT, {
                                                fontSize: "14px",
                                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Don't have an account?")
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                onClick: handleSignUp,
                                                style: {
                                                    color: theme.palette.primary.main,
                                                    textDecoration: "underline",
                                                    cursor: "pointer"
                                                },
                                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign Up")
                                            })
                                        ]
                                    })
                                })
                            ]
                        })
                    ]
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignInForm);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 35080:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45269);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22021);
/* harmony import */ var _landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77591);
/* harmony import */ var _SignInForm__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(72823);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67759);
/* harmony import */ var api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(87461);
/* harmony import */ var api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(54675);
/* harmony import */ var api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(10550);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(61859);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(86201);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var redux_slices_cart__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(23614);
/* harmony import */ var redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(65337);
/* harmony import */ var redux_slices_wishList__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(64134);
/* harmony import */ var utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(81261);
/* harmony import */ var utils_toasterMessages__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(70557);
/* harmony import */ var _api_manage_hooks_react_query_add_cart_useGetAllCartList__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(68184);
/* harmony import */ var _api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(83291);
/* harmony import */ var _header_second_navbar_SecondNavbar__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(59164);
/* harmony import */ var _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(44442);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(86390);
/* harmony import */ var _AuthHeader__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(4561);
/* harmony import */ var _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(79180);
/* harmony import */ var _social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(75294);
/* harmony import */ var components_auth_state__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(75488);
/* harmony import */ var components_auth_sign_in_loginHepler__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(50421);
/* harmony import */ var components_auth_sign_in_OtpLogin__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(59856);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(4173);
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(90603);
/* harmony import */ var api_manage_hooks_react_query_useGetBookingList__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(21163);
/* harmony import */ var api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(93749);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_5__, _SignInForm__WEBPACK_IMPORTED_MODULE_7__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__, api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_9__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_10__, api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_11__, react_hot_toast__WEBPACK_IMPORTED_MODULE_14__, utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__, _api_manage_hooks_react_query_add_cart_useGetAllCartList__WEBPACK_IMPORTED_MODULE_20__, _api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_21__, _header_second_navbar_SecondNavbar__WEBPACK_IMPORTED_MODULE_22__, _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_23__, _AuthHeader__WEBPACK_IMPORTED_MODULE_25__, _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_26__, _social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__, components_auth_sign_in_OtpLogin__WEBPACK_IMPORTED_MODULE_30__, api_manage_hooks_react_query_useGetBookingList__WEBPACK_IMPORTED_MODULE_33__, api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_34__]);
([i18next__WEBPACK_IMPORTED_MODULE_5__, _SignInForm__WEBPACK_IMPORTED_MODULE_7__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__, api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_9__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_10__, api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_11__, react_hot_toast__WEBPACK_IMPORTED_MODULE_14__, utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__, _api_manage_hooks_react_query_add_cart_useGetAllCartList__WEBPACK_IMPORTED_MODULE_20__, _api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_21__, _header_second_navbar_SecondNavbar__WEBPACK_IMPORTED_MODULE_22__, _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_23__, _AuthHeader__WEBPACK_IMPORTED_MODULE_25__, _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_26__, _social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__, components_auth_sign_in_OtpLogin__WEBPACK_IMPORTED_MODULE_30__, api_manage_hooks_react_query_useGetBookingList__WEBPACK_IMPORTED_MODULE_33__, api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_34__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






































const SignIn = ({ modalFor , configData , setModalFor , setLoginInfo , setJwtToken , setUserInfo , handleSuccess , setMedium , zoneid , loginMutation , loginIsLoading , verificationId , sendOTP , handleClose  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_13__.useRouter)();
    const previousRouteName = router.query.from;
    const guestId = (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_35__/* .getGuestId */ .P)();
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_15__.useDispatch)();
    const [openModuleSelection, setOpenModuleSelection] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const [openOtpModal, setOpenOtpModal] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const [loginValue, setLoginValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [otpData, setOtpData] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)({
        type: ""
    });
    const [mainToken, setMainToken] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [isApiCalling, setIsApiCalling] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const [isRemember, setIsRemember] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.useTheme)();
    const [state, loginDispatch] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useReducer)(components_auth_state__WEBPACK_IMPORTED_MODULE_28__/* .loginReducer */ .t, components_auth_state__WEBPACK_IMPORTED_MODULE_28__/* .loginInitialState */ .z6);
    let userDatafor = undefined;
    const moduleType = (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_36__/* .getCurrentModuleType */ .X)();
    if (false) {}
    const loginFormik = (0,formik__WEBPACK_IMPORTED_MODULE_12__.useFormik)({
        initialValues: {
            email_or_phone: userDatafor?.email_or_phone || "",
            password: userDatafor ? userDatafor.password : "",
            tandc: false
        },
        validationSchema: yup__WEBPACK_IMPORTED_MODULE_31__.object({
            email_or_phone: yup__WEBPACK_IMPORTED_MODULE_31__.string().required((0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Email or phone number is required")).test("email-or-phone", (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Must be a valid email or phone number"), function(value) {
                // Regular expressions for validation
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/; // Basic email regex
                const phoneRegex = /^\+?[1-9]\d{1,14}$/; // E.164 format for phone numbers
                // Check if value matches either email or phone regex
                return emailRegex.test(value) || phoneRegex.test(value);
            }),
            password: yup__WEBPACK_IMPORTED_MODULE_31__.string().min(6, (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Password is too short - should be 6 chars minimum.")).required((0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Password is required"))
        }),
        onSubmit: async (values, helpers)=>{
            try {
                if (isRemember) {
                    localStorage.setItem("userDatafor", JSON.stringify(values));
                }
                formSubmitHandler({
                    ...values,
                    login_type: "manual"
                });
            } catch (err) {}
        }
    });
    const cartListSuccessHandler = (res)=>{
        if (res) {
            const tempCartLists = res?.map((item)=>({
                    ...item?.item,
                    cartItemId: item?.id,
                    totalPrice: (0,utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__/* .handleProductValueWithOutDiscount */ .EN)(item?.item) * item?.quantity,
                    selectedAddons: item?.item?.addons,
                    quantity: item?.quantity,
                    food_variations: item?.item?.food_variations,
                    itemBasePrice: item?.item?.price,
                    selectedOption: moduleType !== "food" ? item?.variation : (0,_header_second_navbar_SecondNavbar__WEBPACK_IMPORTED_MODULE_22__/* .getSelectedVariations */ .Ap)(item?.item?.food_variations)
                }));
            dispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_16__/* .setCartList */ .kc)(tempCartLists));
        }
    };
    const { data , refetch: cartListRefetch , isLoading  } = (0,_api_manage_hooks_react_query_add_cart_useGetAllCartList__WEBPACK_IMPORTED_MODULE_20__/* ["default"] */ .Z)(cartListSuccessHandler);
    const bookingSuccess = (res)=>{
        dispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_16__/* .setCartList */ .kc)(res));
    };
    const { data: bookingLists , isLoading: bookingListsIsLoading , refetch: bookingRefetch  } = (0,api_manage_hooks_react_query_useGetBookingList__WEBPACK_IMPORTED_MODULE_33__/* ["default"] */ .Z)((0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_35__/* .getGuestId */ .P)(), bookingSuccess);
    const userOnSuccessHandler = (res)=>{
        dispatch((0,redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_17__/* .setUser */ .av)(res));
    };
    let location = undefined;
    let isModuleSelected = undefined;
    let lanDirection = undefined;
    let languageSetting;
    if (false) {}
    const handleOnChange = (value)=>{
        loginFormik.setFieldValue("email_or_phone", (0,utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__/* .formatPhoneNumber */ .un)(value));
    };
    const passwordHandler = (value)=>{
        loginFormik.setFieldValue("password", value);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        if (otpData?.type !== "") {
            setOpenOtpModal(true);
        }
    }, [
        otpData
    ]);
    const onSuccessHandler = (response)=>{
        dispatch((0,redux_slices_wishList__WEBPACK_IMPORTED_MODULE_18__/* .setWishList */ .Q5)(response));
        setIsApiCalling(false);
    };
    const { refetch: profileRefetch  } = (0,_api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z)(userOnSuccessHandler);
    const { refetch: wishlistRefetch  } = (0,api_manage_hooks_react_query_wish_list_useWishListGet__WEBPACK_IMPORTED_MODULE_11__/* .useWishListGet */ .F)(onSuccessHandler);
    const { refetch: rentalWishlistRefetch  } = (0,api_manage_hooks_react_query_rental_wishlist_useGetWishlist__WEBPACK_IMPORTED_MODULE_34__/* .useGetWishList */ .z)(onSuccessHandler);
    const handleTokenAfterSignIn = async (response)=>{
        if (response) {
            localStorage.setItem("token", response?.token);
            if (moduleType === "rental") {
                await bookingRefetch();
                await rentalWishlistRefetch();
            } else {
                await cartListRefetch();
                await wishlistRefetch();
            }
            await profileRefetch();
            react_hot_toast__WEBPACK_IMPORTED_MODULE_14__["default"].success((0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_37__/* .loginSuccessFull */ .cu));
            if (router.pathname === "/forgot-password") {
                router.push("/home");
            }
            handleClose();
        }
    };
    const handleCloseModuleModal = (item)=>{
        if (item) {
            react_hot_toast__WEBPACK_IMPORTED_MODULE_14__["default"].success((0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_37__/* .moduleSelected */ .s0));
            if (previousRouteName) {
                router.push("/home");
            } else {
                router.back();
            }
        }
        setOpenModuleSelection(false);
    };
    const formSubmitHandler = (values)=>{
        const numberOrEmail = (0,utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_19__/* .checkInput */ .lj)(values?.email_or_phone);
        let newValues = {};
        if (values?.login_type === "otp") {
            newValues = {
                ...values,
                type: "phone",
                guest_id: guestId
            };
        } else {
            newValues = {
                ...values,
                guest_id: guestId,
                field_type: numberOrEmail,
                type: numberOrEmail
            };
        }
        setLoginValue(newValues);
        loginMutation(newValues, {
            onSuccess: async (response)=>{
                if (response?.is_personal_info === 0) {
                    handleLoginInfo(response, {
                        phone: newValues.email_or_phone
                    });
                } else {
                    (0,components_auth_sign_in_loginHepler__WEBPACK_IMPORTED_MODULE_29__/* .getLoginUserCheck */ .h)(response, newValues, handleTokenAfterSignIn, setOtpData, setMainToken, sendOTP, configData);
                }
            },
            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__/* .onErrorResponse */ .RJ
        });
    };
    const { mutate: otpVerifyMutate , isLoading: isLoadingOtpVerifyApi  } = (0,api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_10__/* .useVerifyPhone */ .t)();
    const { mutate: fireBaseOtpMutation , isLoading: fireIsLoading  } = (0,api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_9__/* .useFireBaseOtpVerify */ .b)();
    const handleLoginInfo = (res, values)=>{
        // Common logic to set login info based on response
        setLoginInfo({
            ...res,
            phone: values.phone,
            otp: values?.reset_token
        });
        // Determine which modal to show based on the response
        if (res?.is_personal_info === 0) {
            setModalFor("user_info");
        } else if (res?.is_exist_user !== null) {
            setModalFor("is_exist_user");
        } else {
            setOpenOtpModal(false);
            handleClose();
            handleTokenAfterSignIn(res).then();
        //handleClose();
        }
    };
    const otpFormSubmitHandler = (values)=>{
        if (configData?.firebase_otp_verification === 1) {
            const temValue = {
                session_info: verificationId,
                phone: values.phone,
                otp: values.reset_token,
                login_type: "otp",
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_35__/* .getGuestId */ .P)()
            };
            fireBaseOtpMutation(temValue, {
                onSuccess: (res)=>{
                    if (res) {
                        handleLoginInfo(res, values);
                    }
                },
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__/* .onErrorResponse */ .RJ
            });
        } else {
            let tempValues = {
                phone: values.phone,
                otp: values.reset_token,
                login_type: otpData?.login_type,
                verification_type: otpData?.verification_type,
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_35__/* .getGuestId */ .P)()
            };
            const onSuccessHandler = (res)=>{
                if (res) {
                    handleLoginInfo(res, values);
                }
            };
            otpVerifyMutate(tempValues, {
                onSuccess: onSuccessHandler,
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__/* .onSingleErrorResponse */ .f$
            });
        }
    };
    const rememberMeHandleChange = (e)=>{
        if (e.target.checked) {
            setIsRemember(true);
        } else {
            localStorage.removeItem("userDatafor");
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        const { centralize_login  } = configData || {};
        if (centralize_login) {
            const { otp_login_status , manual_login_status , social_login_status  } = centralize_login;
            loginDispatch({
                type: components_auth_state__WEBPACK_IMPORTED_MODULE_28__/* .ACTIONS.setActiveLoginType */ .aO.setActiveLoginType,
                payload: {
                    otp: otp_login_status === 1,
                    manual: manual_login_status === 1,
                    social: social_login_status === 1
                }
            });
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        (0,components_auth_sign_in_loginHepler__WEBPACK_IMPORTED_MODULE_29__/* .getActiveLoginStatus */ .Z)(state, loginDispatch);
    }, [
        state.activeLoginType
    ]);
    const otpLoginFormik = (0,formik__WEBPACK_IMPORTED_MODULE_12__.useFormik)({
        initialValues: {
            phone: ""
        },
        validationSchema: yup__WEBPACK_IMPORTED_MODULE_31__.object({
            phone: yup__WEBPACK_IMPORTED_MODULE_31__.string().required((0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Please give a phone number")).min(10, "number must be 10 digits")
        }),
        onSubmit: async (values, helpers)=>{
            try {
                formSubmitHandler({
                    ...values,
                    login_type: "otp"
                });
            } catch (err) {}
        }
    });
    const otpHandleChange = (value)=>{
        otpLoginFormik.setFieldValue("phone", `+${value}`);
    };
    const handleClick = ()=>{
        window.open("/terms-and-conditions");
    };
    const selectedOtp = ()=>{
        loginDispatch({
            type: components_auth_state__WEBPACK_IMPORTED_MODULE_28__/* .ACTIONS.setActiveLoginType */ .aO.setActiveLoginType,
            payload: {
                otp: true,
                manual: false,
                social: false
            }
        });
    };
    const handleSignUp = ()=>{
        setModalFor("sign-up");
    //handleClose();
    };
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        if (modalFor === "sign-up") {
            handleClose();
        }
    }, [
        modalFor
    ]);
    const handleFormBasedOnDirection = ()=>{
        switch(state.status){
            case "otp":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_OtpLogin__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                    otpHandleChange: otpHandleChange,
                    otpLoginFormik: otpLoginFormik,
                    configData: configData,
                    isLoading: loginIsLoading,
                    handleClick: handleClick,
                    rememberMeHandleChange: rememberMeHandleChange,
                    handleClose: handleClose
                });
            case "manual":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                    width: "100%",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SignInForm__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        isApiCalling: isApiCalling,
                        configData: configData,
                        handleOnChange: handleOnChange,
                        passwordHandler: passwordHandler,
                        loginFormik: loginFormik,
                        lanDirection: lanDirection?.direction,
                        rememberMeHandleChange: rememberMeHandleChange,
                        isLoading: loginIsLoading,
                        only: true,
                        handleSignUp: handleSignUp,
                        handleClick: handleClick
                    })
                });
            case "social":
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z, {
                    socialLogin: configData?.social_login,
                    configData: configData,
                    state: state,
                    setJwtToken: setJwtToken,
                    setUserInfo: setUserInfo,
                    handleSuccess: handleSuccess,
                    setModalFor: setModalFor,
                    setMedium: setMedium,
                    loginMutation: loginMutation,
                    setLoginInfo: setLoginInfo
                });
            case "otp_manual":
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                    width: "100%",
                    gap: "1rem",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SignInForm__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            isApiCalling: isApiCalling,
                            configData: configData,
                            handleOnChange: handleOnChange,
                            passwordHandler: passwordHandler,
                            loginFormik: loginFormik,
                            lanDirection: lanDirection?.direction,
                            rememberMeHandleChange: rememberMeHandleChange,
                            isLoading: loginIsLoading,
                            handleClick: handleClick
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                            textAlign: "center",
                            fontSize: "14px",
                            color: theme.palette.neutral[400],
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Or")
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                            component: "span",
                            textAlign: "center",
                            fontSize: "14px",
                            fontWeight: "400",
                            color: theme.palette.neutral[400],
                            children: [
                                (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign in with"),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                                    onClick: selectedOtp,
                                    sx: {
                                        textDecoration: "underline",
                                        cursor: "pointer"
                                    },
                                    component: "span",
                                    color: theme.palette.primary.main,
                                    ml: "10px",
                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("OTP")
                                })
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                            alignItems: "center",
                            spacing: 0.5,
                            sx: {
                                paddingTop: "10px !important"
                            },
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                direction: "row",
                                alignItems: "center",
                                justifyContent: "center",
                                spacing: 0.5,
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_6__/* .CustomTypography */ .ZT, {
                                        fontSize: "14px",
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Don't have an account?")
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        onClick: handleSignUp,
                                        style: {
                                            color: theme.palette.primary.main,
                                            textDecoration: "underline",
                                            cursor: "pointer"
                                        },
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign Up")
                                    })
                                ]
                            })
                        })
                    ]
                });
            case "otp_social":
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_OtpLogin__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                            otpHandleChange: otpHandleChange,
                            otpLoginFormik: otpLoginFormik,
                            configData: configData,
                            isLoading: loginIsLoading,
                            handleClick: handleClick,
                            rememberMeHandleChange: rememberMeHandleChange
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                            fontSize: "14px",
                            textAlign: "center",
                            children: [
                                " ",
                                "or login with"
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z, {
                            socialLogin: configData?.social_login,
                            configData: configData,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            handleSuccess: handleSuccess,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        })
                    ]
                });
            case "manual_social":
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                    gap: "1rem",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SignInForm__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            isApiCalling: isApiCalling,
                            configData: configData,
                            handleOnChange: handleOnChange,
                            passwordHandler: passwordHandler,
                            loginFormik: loginFormik,
                            lanDirection: lanDirection?.direction,
                            rememberMeHandleChange: rememberMeHandleChange,
                            isLoading: loginIsLoading,
                            handleClick: handleClick
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                            fontSize: "14px",
                            textAlign: "center",
                            children: [
                                " ",
                                "or login with"
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z, {
                            socialLogin: configData?.social_login,
                            configData: configData,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            handleSuccess: handleSuccess,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                            alignItems: "center",
                            spacing: 0.5,
                            sx: {
                                paddingTop: "10px !important"
                            },
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                direction: "row",
                                alignItems: "center",
                                justifyContent: "center",
                                spacing: 0.5,
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_6__/* .CustomTypography */ .ZT, {
                                        fontSize: "14px",
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Don't have an account?")
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        onClick: handleSignUp,
                                        style: {
                                            color: theme.palette.primary.main,
                                            textDecoration: "underline",
                                            cursor: "pointer"
                                        },
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign Up")
                                    })
                                ]
                            })
                        })
                    ]
                });
            case "all":
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                    gap: "1rem",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SignInForm__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            isApiCalling: isApiCalling,
                            configData: configData,
                            handleOnChange: handleOnChange,
                            passwordHandler: passwordHandler,
                            loginFormik: loginFormik,
                            lanDirection: lanDirection?.direction,
                            rememberMeHandleChange: rememberMeHandleChange,
                            isLoading: loginIsLoading,
                            handleClick: handleClick
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                            gap: "10px",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                                    textAlign: "center",
                                    fontSize: "14px",
                                    color: theme.palette.neutral[400],
                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Or")
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                                    component: "span",
                                    textAlign: "center",
                                    fontSize: "14px",
                                    fontWeight: "400",
                                    color: theme.palette.neutral[400],
                                    children: [
                                        (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign in with"),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                                            onClick: selectedOtp,
                                            sx: {
                                                textDecoration: "underline",
                                                cursor: "pointer"
                                            },
                                            component: "span",
                                            color: theme.palette.primary.main,
                                            ml: "10px",
                                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("OTP")
                                        })
                                    ]
                                })
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_social_login_SocialLogins__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z, {
                            socialLogin: configData?.social_login,
                            configData: configData,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            handleSuccess: handleSuccess,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                            alignItems: "center",
                            spacing: 0.5,
                            sx: {
                                paddingTop: "10px !important"
                            },
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                direction: "row",
                                alignItems: "center",
                                justifyContent: "center",
                                spacing: 0.5,
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_6__/* .CustomTypography */ .ZT, {
                                        fontSize: "14px",
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Don't have an account?")
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        onClick: handleSignUp,
                                        style: {
                                            color: theme.palette.primary.main,
                                            textDecoration: "underline",
                                            cursor: "pointer"
                                        },
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Sign Up")
                                    })
                                ]
                            })
                        })
                    ]
                });
            default:
                return null; // Fallback if no conditions are met
        }
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.NoSsr, {
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                    justifyContent: "center",
                    alignItems: "center",
                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Box, {
                        sx: {
                            maxWidth: "450px",
                            minWidth: {
                                xs: "300px",
                                md: "400px"
                            },
                            padding: {
                                xs: "30px",
                                md: "47px"
                            },
                            position: "relative"
                        },
                        width: "100%",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, {
                                onClick: handleClose,
                                sx: {
                                    zIndex: "99",
                                    position: "absolute",
                                    top: 6,
                                    right: 6,
                                    backgroundColor: (theme)=>theme.palette.neutral[100],
                                    borderRadius: "50%",
                                    [theme.breakpoints.down("sm")]: {
                                        top: -0,
                                        right: -0
                                    }
                                },
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_32___default()), {
                                    sx: {
                                        fontSize: {
                                            xs: "16px",
                                            sm: "18px",
                                            md: "20px"
                                        },
                                        fontWeight: "500"
                                    }
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                spacing: 2,
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AuthHeader__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z, {
                                        configData: configData
                                    }),
                                    handleFormBasedOnDirection()
                                ]
                            })
                        ]
                    })
                })
            }),
            openModuleSelection && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_23__/* .ModuleSelection */ .U, {
                location: location,
                closeModal: handleCloseModuleModal,
                disableAutoFocus: true
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z, {
                handleClose: ()=>setOpenOtpModal(false),
                openModal: openOtpModal,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_26__/* ["default"] */ .Z, {
                    data: otpData?.type ? otpData?.type : loginFormik?.values?.phone,
                    formSubmitHandler: otpFormSubmitHandler,
                    isLoading: isLoadingOtpVerifyApi || fireIsLoading,
                    recaptcha: "recaptcha-container",
                    loginValue: loginValue,
                    reSendOtp: formSubmitHandler,
                    handleClose: ()=>setOpenOtpModal(false)
                })
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignIn);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 50421:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getActiveLoginStatus),
/* harmony export */   "h": () => (/* binding */ getLoginUserCheck)
/* harmony export */ });
/* harmony import */ var components_auth_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75488);

const getActiveLoginStatus = (state, loginDispatch)=>{
    const { otp , manual , social  } = state.activeLoginType;
    let newStatus = "";
    switch(true){
        case otp && manual && social:
            newStatus = "all";
            break;
        case otp && manual:
            newStatus = "otp_manual";
            break;
        case otp && social:
            newStatus = "otp_social";
            break;
        case manual && social:
            newStatus = "manual_social";
            break;
        case otp:
            newStatus = "otp";
            break;
        case manual:
            newStatus = "manual";
            break;
        case social:
            newStatus = "social";
            break;
        default:
            newStatus = "manual";
    }
    loginDispatch({
        type: components_auth_state__WEBPACK_IMPORTED_MODULE_0__/* .ACTIONS.setStatus */ .aO.setStatus,
        payload: newStatus
    });
};
const getLoginUserCheck = (response, data, handleTokenAfter, setOtpData, setMainToken, sendOTP, configData)=>{
    const isPhoneVerified = Number.parseInt(response?.is_phone_verified) === 1;
    const isEmailVerified = Number.parseInt(response?.is_email_verified) === 1;
    if (isPhoneVerified && isEmailVerified) {
        handleTokenAfter(response);
    } else {
        if (!isPhoneVerified && !isEmailVerified) {
            setOtpData({
                ...response,
                type: data?.email_or_phone,
                verification_type: "phone"
            });
        } else if (!isEmailVerified) {
            setOtpData({
                ...response,
                type: data?.email,
                verification_type: "email"
            });
        } else if (!isPhoneVerified) {
            if (configData?.firebase_otp_verification === 1) {
                sendOTP(response, setOtpData, setMainToken, data?.phone);
            } else {
                setOtpData({
                    ...response,
                    type: data?.phone,
                    verification_type: "phone"
                });
            }
        }
        setMainToken(response);
    }
};


/***/ }),

/***/ 5611:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_apple_login__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31487);
/* harmony import */ var react_apple_login__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_apple_login__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var utils_staticCredential__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13835);
/* harmony import */ var components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71921);
/* harmony import */ var components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58861);
/* harmony import */ var _asset_Apple_Logo_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(84406);
/* harmony import */ var jwt_decode__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(45567);
/* harmony import */ var jwt_decode__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jwt_decode__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(61859);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(67759);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__, components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_11__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_5__, components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const AppleLoginComp = (props)=>{
    const { socialLength , state , configData , item , loginMutation , handleSuccess , setMedium , setLoginInfo , setModalFor , setJwtToken , setUserInfo  } = props;
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.useMediaQuery)(theme.breakpoints.down("md"));
    const credentials = utils_staticCredential__WEBPACK_IMPORTED_MODULE_6__/* .appleLoginCredential */ .Xx;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const [appleSdkLoaded, setAppleSdkLoaded] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [loginValue, setLoginValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    // client_id
    // Load Apple SDK
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (typeof AppleID !== "undefined") {
            setAppleSdkLoaded(true);
        } else {
            console.warn("Apple SDK not loaded");
        }
    }, []); // Only runs once when the component mounts
    const handleToken = (token)=>{
        if (token) {
            handleSuccess(token);
        } else {
            setMedium("apple");
        //setModalFor("phone_modal");
        //setOpenModal(true);
        }
    };
    const handlePostRequestOnSuccess = (response)=>{
        const res = response;
        if (response?.is_exist_user === null && response?.is_personal_info === 1) {
            handleToken(response?.token);
        } else if (response?.is_personal_info === 0) {
            setLoginInfo({
                ...res,
                email: response?.email,
                is_email: true
            });
            // setForWidth(false);
            setModalFor("user_info");
        } else {
            // setForWidth(false);
            setMedium("apple");
            setLoginInfo({
                ...res,
                email: response?.email,
                is_email: true
            });
            setModalFor("is_exist_user");
        }
    };
    const handleAppleResponse = async (res)=>{
        if (res.authorization?.id_token) {
            const userObj = jwt_decode__WEBPACK_IMPORTED_MODULE_10___default()(res.authorization?.id_token);
            setJwtToken({
                credential: res?.authorization?.id_token,
                clientId: res?.authorization?.code
            });
            setUserInfo(userObj);
            const tempValue = {
                email: res?.email ?? userObj?.email,
                token: res.authorization?.id_token,
                unique_id: res.authorization?.code ?? res?.clientId,
                medium: res?.medium ?? "apple",
                login_type: res?.login_type ?? "social",
                guest_id: loginValue?.guest_id ?? (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_12__/* .getGuestId */ .P)()
            };
            //setLoginValue(tempValue);
            // const tempValue = {
            //   token: res?.token,
            //   unique_id: res?.code,
            //   medium: "apple",
            //   login_type: "social",
            //   guest_id: getGuestId(),
            // };
            setLoginValue(tempValue);
            loginMutation(tempValue, {
                onSuccess: (res)=>handlePostRequestOnSuccess({
                        ...res,
                        email: userObj?.email
                    }),
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_11__/* .onErrorResponse */ .RJ
            });
        }
    // Handle the response from Apple here
    };
    const handleView = (handleClick)=>{
        if (state?.status === "social") {
            return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* .CustomGoogleButton */ .e, {
                direction: "row",
                spacing: 1,
                width: isSmall ? "275px" : "320px",
                onClick: handleClick,
                sx: {
                    marginInlineStart: {
                        xs: "13px",
                        md: "15px"
                    }
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        src: _asset_Apple_Logo_svg__WEBPACK_IMPORTED_MODULE_9__/* ["default"].src */ .Z.src,
                        alt: "apple",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                        fontSize: "14px",
                        fontWeight: "600",
                        children: t("Continue with Apple")
                    })
                ]
            });
        }
        switch(socialLength){
            case 1:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* .CustomGoogleButton */ .e, {
                    onClick: handleClick,
                    direction: "row",
                    spacing: 1,
                    width: "100%",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                            src: _asset_Apple_Logo_svg__WEBPACK_IMPORTED_MODULE_9__/* ["default"].src */ .Z.src,
                            alt: "apple",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: t("Continue with Apple")
                        })
                    ]
                });
            case 2:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* .CustomGoogleButton */ .e, {
                    onClick: handleClick,
                    direction: "row",
                    spacing: 1,
                    width: "100%",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                            src: _asset_Apple_Logo_svg__WEBPACK_IMPORTED_MODULE_9__/* ["default"].src */ .Z.src,
                            alt: "apple",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: t("Apple")
                        })
                    ]
                });
            case 3:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* .CustomGoogleButton */ .e, {
                    onClick: handleClick,
                    direction: "row",
                    spacing: 1,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        src: _asset_Apple_Logo_svg__WEBPACK_IMPORTED_MODULE_9__/* ["default"].src */ .Z.src,
                        alt: "apple",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    })
                });
            default:
                return null;
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        style: {
            width: socialLength === 3 && state?.status !== "social" ? "45px" : "100%"
        },
        children: appleSdkLoaded ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_apple_login__WEBPACK_IMPORTED_MODULE_3___default()), {
            clientId: configData?.apple_login[0]?.client_id,
            redirectURI: configData?.apple_login[0]?.redirect_url_react,
            responseType: "code",
            responseMode: "form_post",
            usePopup: true,
            callback: handleAppleResponse,
            scope: "email name",
            render: (renderProps // Custom Apple Sign-in Button
            )=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: handleView(renderProps.onClick)
                })
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
            children: t("Loading Apple Login...")
        })
    });
};
AppleLoginComp.propTypes = {
    socialLength: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number.isRequired),
    state: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AppleLoginComp);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44855:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_facebook_login_dist_facebook_login_render_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66804);
/* harmony import */ var react_facebook_login_dist_facebook_login_render_props__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_facebook_login_dist_facebook_login_render_props__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86201);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67759);
/* harmony import */ var api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(54675);
/* harmony import */ var api_manage_hooks_react_query_social_login_useEmailPost__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(32399);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(46573);
/* harmony import */ var redux_slices_fbCredentials__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(50307);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(45269);
/* harmony import */ var utils_staticCredential__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13835);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(58861);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(86390);
/* harmony import */ var _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(79180);
/* harmony import */ var components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71921);
/* harmony import */ var _asset_Facebook_png__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(57008);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(61859);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hot_toast__WEBPACK_IMPORTED_MODULE_4__, react_i18next__WEBPACK_IMPORTED_MODULE_5__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_7__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_8__, api_manage_hooks_react_query_social_login_useEmailPost__WEBPACK_IMPORTED_MODULE_9__, _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_15__, components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__]);
([react_hot_toast__WEBPACK_IMPORTED_MODULE_4__, react_i18next__WEBPACK_IMPORTED_MODULE_5__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_7__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_8__, api_manage_hooks_react_query_social_login_useEmailPost__WEBPACK_IMPORTED_MODULE_9__, _sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_15__, components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




















const FbLoginComp = (props)=>{
    const { handleSuccess , configData , socialLength , state , setModalFor , setMedium , loginMutation , setLoginInfo  } = props;
    const { userInfo , jwtToken  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state.fbCredentialsStore);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useMediaQuery)(theme.breakpoints.down("md"));
    const [loginValue, setLoginValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [openModal, setOpenModal] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [openOtpModal, setOpenOtpModal] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [otpData, setOtpData] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({
        phone: ""
    });
    const [mainToken, setMainToken] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useDispatch)();
    const appId = utils_staticCredential__WEBPACK_IMPORTED_MODULE_12__/* .fb_app_id */ .i_;
    const { mutate  } = (0,api_manage_hooks_react_query_social_login_useEmailPost__WEBPACK_IMPORTED_MODULE_9__/* .usePostEmail */ .v)();
    const handleToken = (response)=>{
        if (response?.token) {
            handleSuccess(response.token);
        } else {
            setMedium("facebook");
            setModalFor("phone_modal");
            setOpenModal(true);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (otpData?.phone !== "") {
            setOpenOtpModal(true);
        }
    }, [
        otpData
    ]);
    const handlePostRequestOnSuccess = (response)=>{
        const res = response?.data;
        if (response?.data?.is_exist_user === null && response?.data?.is_personal_info === 1) {
            handleToken(response?.data);
        } else if (response?.data?.is_personal_info === 0) {
            setLoginInfo({
                ...res,
                email: response?.data?.email,
                is_email: true
            });
            setModalFor("user_info");
        } else {
            setMedium("facebook");
            setLoginInfo({
                ...res,
                email: response?.data?.email,
                is_email: true
            });
            setModalFor("is_exist_user");
        }
    };
    const responseFacebook = async (res)=>{
        dispatch((0,redux_slices_fbCredentials__WEBPACK_IMPORTED_MODULE_10__/* .setUserInfoByDispatch */ .kv)(res));
        dispatch((0,redux_slices_fbCredentials__WEBPACK_IMPORTED_MODULE_10__/* .setJwtTokenByDispatch */ .ij)(res));
        if (res?.status !== "unknown") {
            const tempValue = {
                email: res?.email,
                token: res?.accessToken,
                unique_id: res?.id,
                medium: "facebook",
                phone: res?.phone,
                login_type: "social",
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_18__/* .getGuestId */ .P)()
            };
            setLoginValue(tempValue);
            await mutate(tempValue, {
                onSuccess: (res)=>handlePostRequestOnSuccess({
                        ...res
                    }),
                onError: (error)=>{
                    error?.response?.data?.errors?.forEach((item)=>item.code === "email" ? handleToken() : react_hot_toast__WEBPACK_IMPORTED_MODULE_4__.toast.error(item.message));
                }
            });
        }
    };
    const { mutate: signInMutate , isLoading  } = (0,api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_8__/* .useVerifyPhone */ .t)();
    const onSuccessHandlerOtp = async (res)=>{
        react_hot_toast__WEBPACK_IMPORTED_MODULE_4__.toast.success(res?.message);
        setOpenOtpModal(false);
        setOpenModal(false);
        await handleSuccess(mainToken);
    };
    const formSubmitHandler = (values)=>{
        signInMutate(values, {
            onSuccess: onSuccessHandlerOtp,
            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_7__/* .onErrorResponse */ .RJ
        });
    };
    const handleView = (fbHandler)=>{
        if (state?.status === "social") {
            return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__/* .CustomGoogleButton */ .e, {
                onClick: fbHandler,
                direction: "row",
                spacing: 1,
                width: isSmall ? "275px" : "320px",
                sx: {
                    marginInlineStart: {
                        xs: "13px !important",
                        sm: "13px !important",
                        md: "0px"
                    }
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                        src: _asset_Facebook_png__WEBPACK_IMPORTED_MODULE_17__/* ["default"].src */ .Z.src,
                        alt: "facebook",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                        fontSize: "14px",
                        fontWeight: "600",
                        children: t("Continue with Facebook")
                    })
                ]
            });
        }
        switch(socialLength){
            case 1:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__/* .CustomGoogleButton */ .e, {
                    direction: "row",
                    spacing: 1,
                    width: "100%",
                    onClick: fbHandler,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                            src: _asset_Facebook_png__WEBPACK_IMPORTED_MODULE_17__/* ["default"].src */ .Z.src,
                            alt: "facebook",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: t("Continue with Facebook")
                        })
                    ]
                });
            case 2:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__/* .CustomGoogleButton */ .e, {
                    direction: "row",
                    spacing: 1,
                    width: "100%",
                    onClick: fbHandler,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                            src: _asset_Facebook_png__WEBPACK_IMPORTED_MODULE_17__/* ["default"].src */ .Z.src,
                            alt: "facebook",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: t("Facebook")
                        })
                    ]
                });
            case 3:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_social_login_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_16__/* .CustomGoogleButton */ .e, {
                    direction: "row",
                    spacing: 1,
                    onClick: fbHandler,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                        src: _asset_Facebook_png__WEBPACK_IMPORTED_MODULE_17__/* ["default"].src */ .Z.src,
                        alt: "facebook",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    })
                });
            default:
                break;
        }
    };
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_19__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_19__/* .getLanguage */ .G)() : "ltr";
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_facebook_login_dist_facebook_login_render_props__WEBPACK_IMPORTED_MODULE_3___default()), {
                appId: appId,
                autoLoad: false,
                fields: "name,email,picture",
                callback: responseFacebook,
                render: (renderProps)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: handleView(renderProps.onClick)
                    })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                openModal: openOtpModal,
                setModalOpen: setOpenOtpModal,
                handleClose: ()=>setOpenModal(false),
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_sign_up_OtpForm__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                    data: otpData,
                    formSubmitHandler: formSubmitHandler,
                    isLoading: isLoading,
                    loginValue: loginValue
                })
            })
        ]
    });
};
FbLoginComp.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FbLoginComp);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 71921:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "e": () => (/* binding */ CustomGoogleButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jwt_decode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45567);
/* harmony import */ var jwt_decode__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jwt_decode__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86201);
/* harmony import */ var utils_staticCredential__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13835);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58861);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _asset_Google_Logo_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(69473);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(22021);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61859);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hot_toast__WEBPACK_IMPORTED_MODULE_3__, i18next__WEBPACK_IMPORTED_MODULE_9__]);
([react_hot_toast__WEBPACK_IMPORTED_MODULE_3__, i18next__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const CustomGoogleButton = (0,_mui_system__WEBPACK_IMPORTED_MODULE_5__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack)(({ theme , width , height  })=>({
        width: width,
        backgroundColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.alpha)(theme.palette.neutral[400], 0.1),
        height: height ?? "45px",
        justifyContent: "center",
        borderRadius: "5px",
        padding: "10px",
        color: theme.palette.neutral[600],
        border: "1px",
        borderColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.alpha)(theme.palette.primary.main, 0.6),
        alignItems: "center",
        cursor: "pointer"
    }));
const GoogleLoginComp = (props)=>{
    const { handleSuccess , socialLength , state , setJwtToken , setUserInfo , setModalFor , setMedium , loginMutation , setLoginInfo  } = props;
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.useTheme)();
    const [loginValue, setLoginValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const [openModal, setOpenModal] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [openOtpModal, setOpenOtpModal] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [otpData, setOtpData] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({
        phone: ""
    });
    const buttonDiv = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_7__.useMediaQuery)(theme.breakpoints.down("md"));
    const [buttonWidth, setButtonWidth] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(isSmall ? "300px" : "350px"); // Default width
    const clientId = utils_staticCredential__WEBPACK_IMPORTED_MODULE_4__/* .google_client_id */ .q$;
    // Update button size based on socialLength
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>{
        switch(socialLength){
            case 1:
                setButtonWidth("300px");
                break;
            case 2:
                setButtonWidth("147px");
                break;
            case 3:
                setButtonWidth("50px");
                break;
            default:
                setButtonWidth("350px !important");
        }
        if (state?.status === "social") {
            setButtonWidth("306px !important");
        }
    }, [
        socialLength,
        state?.status
    ]);
    const handleToken = (token)=>{
        if (token) {
            handleSuccess(token);
        } else {
            setMedium("google");
            setModalFor("phone_modal");
            setOpenModal(true);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>{
        if (otpData?.phone !== "") {
            setOpenOtpModal(true);
        }
    }, [
        otpData
    ]);
    const handlePostRequestOnSuccess = (response)=>{
        const res = response;
        if (response?.is_exist_user === null && response?.is_personal_info === 1) {
            handleToken(response?.token);
        } else if (response?.is_personal_info === 0) {
            setLoginInfo({
                ...res,
                email: response?.email,
                is_email: true
            });
            // setForWidth(false);
            setModalFor("user_info");
        } else {
            // setForWidth(false);
            setMedium("google");
            setLoginInfo({
                ...res,
                email: response?.email,
                is_email: true
            });
            setModalFor("is_exist_user");
        }
    };
    const handleCallBackResponse = (res)=>{
        const userObj = jwt_decode__WEBPACK_IMPORTED_MODULE_1___default()(res.credential);
        setJwtToken(res);
        setUserInfo(userObj);
        const tempValue = {
            email: res?.email ?? userObj.email,
            token: res?.token ?? res.credential,
            unique_id: res?.unique_id ?? res?.clientId,
            medium: res?.medium ?? "google",
            login_type: res?.login_type ?? "social",
            guest_id: loginValue?.guest_id ?? (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_10__/* .getGuestId */ .P)()
        };
        setLoginValue(tempValue);
        loginMutation(tempValue, {
            onSuccess: (res)=>handlePostRequestOnSuccess({
                    ...res,
                    email: userObj.email
                }),
            onError: (error)=>{
                error?.response?.data?.errors?.forEach((item)=>item.code === "email" ? handleToken() : react_hot_toast__WEBPACK_IMPORTED_MODULE_3__.toast.error(item.message));
            }
        });
        const handleRegistrationOnSuccess = (token)=>{
            //registration on success func remaining
            setOpenModal(false);
            handleSuccess(token);
        };
    };
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>{
        // Initialize Google button
        if (true) {
            window?.google?.accounts?.id?.initialize({
                client_id: clientId,
                callback: handleCallBackResponse
            });
            window?.google?.accounts?.id?.renderButton(buttonDiv.current, {
                theme: "outline",
                size: "large",
                logo_alignment: "left"
            });
        }
    }, []);
    const handleView = ()=>{
        // Handle conditional rendering for social login button style
        if (state?.status === "social") {
            return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomGoogleButton, {
                direction: "row",
                spacing: 1,
                width: "100%",
                height: "50px",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        src: _asset_Google_Logo_png__WEBPACK_IMPORTED_MODULE_8__/* ["default"].src */ .Z.src,
                        alt: "facebook",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Typography, {
                        fontSize: "14px",
                        fontWeight: "600",
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_9__.t)("Continue with Google")
                    })
                ]
            });
        }
        switch(socialLength){
            case 1:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomGoogleButton, {
                    direction: "row",
                    spacing: 1,
                    width: "280px",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            src: _asset_Google_Logo_png__WEBPACK_IMPORTED_MODULE_8__/* ["default"].src */ .Z.src,
                            alt: "facebook",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_9__.t)("Continue with Google")
                        })
                    ]
                });
            case 2:
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomGoogleButton, {
                    direction: "row",
                    spacing: 1,
                    width: "100%",
                    height: "50px",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            src: _asset_Google_Logo_png__WEBPACK_IMPORTED_MODULE_8__/* ["default"].src */ .Z.src,
                            alt: "facebook",
                            height: "24px",
                            width: "24px",
                            objectFit: "cover",
                            borderRadius: "50%"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_7__.Typography, {
                            fontSize: "14px",
                            fontWeight: "600",
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_9__.t)("Google")
                        })
                    ]
                });
            case 3:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomGoogleButton, {
                    direction: "row",
                    width: "100%",
                    spacing: 1,
                    height: "50px",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        src: _asset_Google_Logo_png__WEBPACK_IMPORTED_MODULE_8__/* ["default"].src */ .Z.src,
                        alt: "facebook",
                        height: "24px",
                        width: "24px",
                        objectFit: "cover",
                        borderRadius: "50%"
                    })
                });
            default:
                return null;
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
        width: socialLength === 3 && state?.status !== "social" ? "45px" : "100%",
        maxWidth: "355px",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            style: {
                position: "relative",
                width: socialLength !== 3 ? "100%" : buttonWidth,
                overflow: "hidden",
                transform: "scale(0.9)",
                transformOrigin: "center center",
                cursor: "pointer"
            },
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    style: {
                        position: "absolute",
                        width: "100%",
                        filter: "opacity(0)",
                        zIndex: 9999
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        ref: buttonDiv
                    })
                }),
                handleView()
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GoogleLoginComp);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 20746:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76829);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(57987);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(67759);
/* harmony import */ var _api_manage_hooks_react_query_auth_usePostRegisterInfo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(40657);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(45269);
/* harmony import */ var _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(67294);
/* harmony import */ var _custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(65304);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_4__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_6__, _api_manage_hooks_react_query_auth_usePostRegisterInfo__WEBPACK_IMPORTED_MODULE_7__, _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_9__, _custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_10__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_4__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_6__, _api_manage_hooks_react_query_auth_usePostRegisterInfo__WEBPACK_IMPORTED_MODULE_7__, _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_9__, _custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const PhoneInputForm = (props)=>{
    const { userInfo , jwtToken , medium , handleRegistrationOnSuccess , configData , lanDirection  } = props;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const { mutate , isLoading  } = (0,_api_manage_hooks_react_query_auth_usePostRegisterInfo__WEBPACK_IMPORTED_MODULE_7__/* .usePostRegisterInfo */ .H)();
    const formik = (0,formik__WEBPACK_IMPORTED_MODULE_3__.useFormik)({
        initialValues: {
            phone: ""
        },
        validationSchema: yup__WEBPACK_IMPORTED_MODULE_5__.object({
            phone: yup__WEBPACK_IMPORTED_MODULE_5__.string().required(t("Please give a phone number")).min(10, "number must be 10 digits")
        }),
        onSubmit: async (values, helpers)=>{
            try {
                handleOnSubmitFormik(values);
            } catch (err) {}
        }
    });
    const handleOnSubmitFormik = (values)=>{
        const info = {
            email: userInfo?.email,
            token: jwtToken?.credential,
            unique_id: jwtToken?.clientId,
            medium: medium,
            phone: values.phone,
            id_token: true
        };
        mutate(info, {
            onSuccess: (response)=>{
                handleRegistrationOnSuccess(response?.token, response?.is_phone_verified, values.phone);
            },
            onError: _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_6__/* .onErrorResponse */ .RJ
        });
    };
    const handleOnChange = (value)=>{
        formik.setFieldValue("phone", `+${value}`);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Paper, {
        sx: {
            padding: "1rem",
            position: "relative"
        },
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
            onSubmit: formik.handleSubmit,
            noValidate: true,
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_8__/* .CustomStackFullWidth */ .Xw, {
                spacing: 2,
                sx: {
                    position: "relative"
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_alert_CustomAlert__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                        type: "info",
                        text: t("Give a valid phone number to continue sign-in")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
                        value: formik.values.phone,
                        onHandleChange: handleOnChange,
                        initCountry: configData?.country,
                        touched: formik.touched.phone,
                        errors: formik.errors.phone,
                        lanDirection: lanDirection
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_1___default()), {
                        type: "submit",
                        fullWidth: true,
                        variant: "contained",
                        loading: isLoading,
                        children: t("Continue")
                    })
                ]
            })
        })
    });
};
PhoneInputForm.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PhoneInputForm);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 75294:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _GoogleLoginComp__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71921);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(57987);
/* harmony import */ var _FbLoginComp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(44855);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var components_auth_sign_in_social_login_AppleLoginComp__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5611);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_3__, react_i18next__WEBPACK_IMPORTED_MODULE_4__, _FbLoginComp__WEBPACK_IMPORTED_MODULE_5__, components_auth_sign_in_social_login_AppleLoginComp__WEBPACK_IMPORTED_MODULE_7__]);
([_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_3__, react_i18next__WEBPACK_IMPORTED_MODULE_4__, _FbLoginComp__WEBPACK_IMPORTED_MODULE_5__, components_auth_sign_in_social_login_AppleLoginComp__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const SocialLogins = (props)=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { socialLogin , configData , state , setJwtToken , setUserInfo , handleSuccess , setModalFor , setMedium , loginMutation , setLoginInfo  } = props;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const combineLoginData = [
        ...socialLogin,
        ...configData?.apple_login
    ];
    const dataWithCentralize = combineLoginData.map((item)=>({
            ...item,
            ...configData?.centralize_login || {}
        }));
    const dataWithCentralizeFiltered = dataWithCentralize.filter((item)=>{
        if (item?.login_medium === "google") {
            return item?.status === true && configData?.centralize_login?.google_login_status === 1;
        }
        if (item?.login_medium === "facebook") {
            return item?.status === true && configData?.centralize_login?.facebook_login_status === 1;
        }
        if (item?.login_medium === "apple") {
            return item?.status === true && configData?.centralize_login?.apple_login_status === 1;
        }
        return true; // Keep the item if it's not related to google, facebook, or apple
    });
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack, {
        alignItems: "center",
        justifyContent: "center",
        spacing: state?.status === "social" ? 2 : 1,
        direction: socialLogin?.length === 1 && state?.status === "all" || state?.status === "social" ? "column" : "row",
        width: "100%",
        children: [
            socialLogin?.length === 1 && state?.status === "all" || state?.status === "social" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                fontSize: "16px",
                children: t(`Welcome to ${configData?.business_name} `)
            }),
            state?.status === "social" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack, {
                gap: 2,
                direction: socialLogin?.length === 1 && state?.status === "all" || state?.status === "social" ? "column" : "row",
                children: dataWithCentralizeFiltered?.map((item, index)=>{
                    if (item?.login_medium === "google" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }, index);
                    } else if (item?.login_medium === "facebook" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_FbLoginComp__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            //handleParentModalClose={handleParentModalClose}
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }, index);
                    } else if (item?.login_medium === "apple" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_social_login_AppleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            //handleParentModalClose={handleParentModalClose}
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo,
                            item: item
                        }, index);
                    }
                })
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: dataWithCentralizeFiltered?.map((item, index)=>{
                    if (item?.login_medium === "google" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_GoogleLoginComp__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }, index);
                    } else if (item?.login_medium === "facebook" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_FbLoginComp__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            //handleParentModalClose={handleParentModalClose}
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo
                        }, index);
                    } else if (item?.login_medium === "apple" && item?.status === true) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_auth_sign_in_social_login_AppleLoginComp__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            handleSuccess: handleSuccess,
                            configData: configData,
                            socialLength: dataWithCentralizeFiltered?.length,
                            state: state,
                            setJwtToken: setJwtToken,
                            setUserInfo: setUserInfo,
                            setModalFor: setModalFor,
                            setMedium: setMedium,
                            loginMutation: loginMutation,
                            setLoginInfo: setLoginInfo,
                            item: item
                        }, index);
                    }
                })
            })
        ]
    });
};
SocialLogins.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(SocialLogins));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8218:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22021);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45269);
/* harmony import */ var _AuthHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4561);
/* harmony import */ var _SignUpForm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81321);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76829);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(67759);
/* harmony import */ var api_manage_hooks_react_query_auth_useSignUp__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(35432);
/* harmony import */ var api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(87461);
/* harmony import */ var api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(54675);
/* harmony import */ var api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(83291);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(61859);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(86201);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(65337);
/* harmony import */ var redux_slices_utils__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(67493);
/* harmony import */ var utils_toasterMessages__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(70557);
/* harmony import */ var _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(44442);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(86390);
/* harmony import */ var _AcceptTermsAndConditions__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(44657);
/* harmony import */ var _OtpForm__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(79180);
/* harmony import */ var _SignUpValidation__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(49792);
/* harmony import */ var components_auth_sign_in_loginHepler__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(50421);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(90603);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_2__, _AuthHeader__WEBPACK_IMPORTED_MODULE_5__, _SignUpForm__WEBPACK_IMPORTED_MODULE_6__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__, api_manage_hooks_react_query_auth_useSignUp__WEBPACK_IMPORTED_MODULE_10__, api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_11__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_12__, api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_13__, react_hot_toast__WEBPACK_IMPORTED_MODULE_16__, _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_20__, _AcceptTermsAndConditions__WEBPACK_IMPORTED_MODULE_22__, _OtpForm__WEBPACK_IMPORTED_MODULE_23__, _SignUpValidation__WEBPACK_IMPORTED_MODULE_24__]);
([i18next__WEBPACK_IMPORTED_MODULE_2__, _AuthHeader__WEBPACK_IMPORTED_MODULE_5__, _SignUpForm__WEBPACK_IMPORTED_MODULE_6__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__, api_manage_hooks_react_query_auth_useSignUp__WEBPACK_IMPORTED_MODULE_10__, api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_11__, api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_12__, api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_13__, react_hot_toast__WEBPACK_IMPORTED_MODULE_16__, _landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_20__, _AcceptTermsAndConditions__WEBPACK_IMPORTED_MODULE_22__, _OtpForm__WEBPACK_IMPORTED_MODULE_23__, _SignUpValidation__WEBPACK_IMPORTED_MODULE_24__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





























const SignUp = ({ configData , setModalFor , sendOTP , handleClose , loginMutation  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_15__.useRouter)();
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_17__.useDispatch)();
    const [openModuleSelection, setOpenModuleSelection] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_8__.useTheme)();
    const [otpData, setOtpData] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)({
        type: ""
    });
    const [mainToken, setMainToken] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [openOtpModal, setOpenOtpModal] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const [selectedModule, setSelectedModule] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [verificationId, setVerificationId] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [loginValue, setLoginValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const guestId = (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__/* .getGuestId */ .P)();
    const signUpFormik = (0,formik__WEBPACK_IMPORTED_MODULE_14__.useFormik)({
        initialValues: {
            name: "",
            email: "",
            phone: "",
            password: "",
            confirm_password: "",
            ref_code: "",
            tandc: false
        },
        validationSchema: (0,_SignUpValidation__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z)(),
        onSubmit: async (values, helpers)=>{
            try {
                formSubmitHandler(values);
            } catch (err) {}
        }
    });
    const handleCloseOtp = ()=>{
        setOpenOtpModal(false);
    };
    const fNameHandler = (value)=>{
        signUpFormik.setFieldValue("name", value);
    };
    const lNameHandler = (value)=>{
        signUpFormik.setFieldValue("l_name", value);
    };
    const emailHandler = (value)=>{
        signUpFormik.setFieldValue("email", value);
    };
    const handleOnChange = (value)=>{
        signUpFormik.setFieldValue("phone", `+${value}`);
    };
    const passwordHandler = (value)=>{
        signUpFormik.setFieldValue("password", value);
    };
    const confirmPasswordHandler = (value)=>{
        signUpFormik.setFieldValue("confirm_password", value);
    };
    const handleCheckbox = (e)=>{
        signUpFormik.setFieldValue("tandc", e.target.checked);
    };
    const ReferCodeHandler = (value)=>{
        signUpFormik.setFieldValue("ref_code", value);
    };
    let location = undefined;
    if (false) {}
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        if (otpData?.type !== "") {
            setOpenOtpModal(true);
        }
    }, [
        otpData
    ]);
    const userOnSuccessHandler = (res)=>{
        dispatch((0,redux_slices_profileInfo__WEBPACK_IMPORTED_MODULE_18__/* .setUser */ .av)(res));
    //handleClose()
    };
    const { data: userData , refetch: profileRefetch  } = (0,api_manage_hooks_react_query_profile_useGetProfile__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z)(userOnSuccessHandler);
    const handleTokenAfterSignUp = (response)=>{
        if (response) {
            localStorage.setItem("token", response?.token);
            profileRefetch();
            react_hot_toast__WEBPACK_IMPORTED_MODULE_16__["default"].success((0,i18next__WEBPACK_IMPORTED_MODULE_2__.t)(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_27__/* .signup_successfull */ .fj));
            dispatch((0,redux_slices_utils__WEBPACK_IMPORTED_MODULE_19__/* .setWelcomeModal */ .TF)(true));
            const zoneSelected = JSON.parse(localStorage.getItem("zoneid"));
            if (zoneSelected && (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_28__/* .getCurrentModuleType */ .X)()) {
                if ((0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_28__/* .getCurrentModuleType */ .X)() !== "parcel") {
                    router.push("/interest", undefined, {
                        shallow: true
                    });
                } else {
                    router.push("/home", undefined, {
                        shallow: true
                    });
                }
            } else {
                router.push("/home", undefined, {
                    shallow: true
                });
            }
            handleClose();
        }
    };
    const handleCloseModuleModal = (item)=>{
        if (item) {
            react_hot_toast__WEBPACK_IMPORTED_MODULE_16__["default"].success((0,i18next__WEBPACK_IMPORTED_MODULE_2__.t)("A Module has been selected."));
            if (signUpFormik.values.ref_code) {
                setSelectedModule(item);
                dispatch((0,redux_slices_utils__WEBPACK_IMPORTED_MODULE_19__/* .setWelcomeModal */ .TF)(true));
            }
            if (item.module_type !== "parcel") {
                router.push("/interest", undefined, {
                    shallow: true
                });
            } else {
                router.push("/home", undefined, {
                    shallow: true
                });
            }
        }
        setOpenModuleSelection(false);
    };
    // const handleCloseWelcomeModal = () => {
    //   if (
    //     selectedModule.module_type === "ecommerce" ||
    //     selectedModule.module_type === "food"
    //   ) {
    //     router.push("/interest", undefined, { shallow: true });
    //   } else {
    //     router.push("/home", undefined, { shallow: true });
    //   }
    // };
    const { mutate , isLoading , error  } = (0,api_manage_hooks_react_query_auth_useSignUp__WEBPACK_IMPORTED_MODULE_10__/* .useSignUp */ .Q)();
    const formSubmitHandler = (values)=>{
        const signUpData = {
            name: values.name,
            email: values.email,
            phone: values.phone,
            password: values.password,
            confirm_password: values.confirm_password,
            ref_code: values.ref_code,
            guest_id: values?.guest_id ?? (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__/* .getGuestId */ .P)()
        };
        setLoginValue(signUpData);
        mutate(signUpData, {
            onSuccess: async (response)=>{
                (0,components_auth_sign_in_loginHepler__WEBPACK_IMPORTED_MODULE_25__/* .getLoginUserCheck */ .h)(response, signUpData, handleTokenAfterSignUp, setOtpData, setMainToken, sendOTP, configData);
            },
            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__/* .onErrorResponse */ .RJ
        });
    };
    const reSendOtp = ()=>{
        const values = {
            email_or_phone: signUpFormik?.values?.phone,
            login_type: "manual",
            password: signUpFormik?.values?.password,
            guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__/* .getGuestId */ .P)(),
            field_type: "phone"
        };
        loginMutation(values);
    };
    const { mutate: otpVerifyMutate , isLoading: isLoadingOtpVerifiyAPi  } = (0,api_manage_hooks_react_query_forgot_password_useVerifyPhone__WEBPACK_IMPORTED_MODULE_12__/* .useVerifyPhone */ .t)();
    const { mutate: fireBaseOtpMutation , isLoading: fireIsLoading  } = (0,api_manage_hooks_react_query_forgot_password_useFIreBaseOtpVerify__WEBPACK_IMPORTED_MODULE_11__/* .useFireBaseOtpVerify */ .b)();
    const otpFormSubmitHandler = (values)=>{
        const onSuccessHandler = (res)=>{
            setOpenOtpModal(false);
            handleTokenAfterSignUp(res);
        };
        if (configData?.firebase_otp_verification === 1 && configData?.centralize_login?.phone_verification_status === 1) {
            const temValue = {
                session_info: verificationId,
                phone: values.phone,
                otp: values.reset_token,
                login_type: "manual",
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__/* .getGuestId */ .P)()
            };
            fireBaseOtpMutation(temValue, {
                onSuccess: onSuccessHandler,
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__/* .onErrorResponse */ .RJ
            });
        } else {
            let tempValues = {
                [otpData?.verification_type]: otpData.type,
                otp: values.reset_token,
                login_type: otpData?.login_type,
                verification_type: otpData?.verification_type,
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_26__/* .getGuestId */ .P)()
            };
            otpVerifyMutate(tempValues, {
                onSuccess: onSuccessHandler,
                onError: (error)=>{
                    react_hot_toast__WEBPACK_IMPORTED_MODULE_16__["default"].error(error?.response?.data?.message, {
                        id: "error"
                    });
                }
            });
        }
    };
    const handleSignIn = ()=>{
        setModalFor("sign-in");
    };
    const handleClick = ()=>{
        window.open("/terms-and-conditions");
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                justifyContent: "center",
                alignItems: "center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                        justifyContent: "center",
                        alignItems: "center",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_1__.Box, {
                            sx: {
                                maxWidth: "650px",
                                padding: {
                                    xs: "30px",
                                    md: "47px"
                                },
                                minWidth: {
                                    xs: "300px",
                                    md: "450px"
                                }
                            },
                            width: "100%",
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                spacing: 2,
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AuthHeader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                        configData: configData
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
                                        noValidate: true,
                                        onSubmit: signUpFormik.handleSubmit,
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                            spacing: 2,
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SignUpForm__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                                    configData: configData,
                                                    handleOnChange: handleOnChange,
                                                    passwordHandler: passwordHandler,
                                                    fNameHandler: fNameHandler,
                                                    lNameHandler: lNameHandler,
                                                    emailHandler: emailHandler,
                                                    confirmPasswordHandler: confirmPasswordHandler,
                                                    ReferCodeHandler: ReferCodeHandler,
                                                    signUpFormik: signUpFormik
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AcceptTermsAndConditions__WEBPACK_IMPORTED_MODULE_22__/* ["default"] */ .Z, {
                                                    handleCheckbox: handleCheckbox,
                                                    handleClick: handleClick,
                                                    formikType: signUpFormik
                                                }),
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                                                    spacing: 2,
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_7___default()), {
                                                            type: "submit",
                                                            fullWidth: true,
                                                            variant: "contained",
                                                            loading: isLoading,
                                                            disabled: !signUpFormik.values.tandc,
                                                            id: "recaptcha-container",
                                                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_2__.t)("Sign Up")
                                                        }),
                                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_8__.Typography, {
                                                            sx: {
                                                                a: {
                                                                    "&:hover": {
                                                                        letterSpacing: "0.03em"
                                                                    }
                                                                }
                                                            },
                                                            children: [
                                                                (0,i18next__WEBPACK_IMPORTED_MODULE_2__.t)("Already have an account?"),
                                                                " ",
                                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                                    onClick: handleSignIn,
                                                                    style: {
                                                                        color: theme.palette.primary.main,
                                                                        textDecoration: "underline",
                                                                        cursor: "pointer"
                                                                    },
                                                                    children: (0,i18next__WEBPACK_IMPORTED_MODULE_2__.t)("Sign In")
                                                                })
                                                            ]
                                                        })
                                                    ]
                                                })
                                            ]
                                        })
                                    })
                                ]
                            })
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z, {
                        handleClose: handleClose,
                        openModal: openOtpModal,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_OtpForm__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
                            data: otpData?.phone,
                            formSubmitHandler: otpFormSubmitHandler,
                            isLoading: isLoadingOtpVerifiyAPi || fireIsLoading
                        })
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z, {
                handleClose: ()=>setOpenOtpModal(false),
                openModal: openOtpModal,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_OtpForm__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
                    data: otpData?.type ? otpData?.type : signUpFormik?.values?.phone,
                    formSubmitHandler: otpFormSubmitHandler,
                    isLoading: isLoadingOtpVerifiyAPi || fireIsLoading,
                    loginValue: loginValue,
                    reSendOtp: reSendOtp,
                    handleClose: ()=>setOpenOtpModal(false)
                })
            }),
            openModuleSelection && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_module_selection__WEBPACK_IMPORTED_MODULE_20__/* .ModuleSelection */ .U, {
                location: location,
                closeModal: handleCloseModuleModal,
                disableAutoFocus: true
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().memo(SignUp));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 81321:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42492);
/* harmony import */ var _custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65304);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22021);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(46573);
/* harmony import */ var _mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1883);
/* harmony import */ var _mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(9026);
/* harmony import */ var _mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12906);
/* harmony import */ var _mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27549);
/* harmony import */ var _mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_4__, i18next__WEBPACK_IMPORTED_MODULE_5__]);
([_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_4__, i18next__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const SignUpForm = ({ configData , handleOnChange , passwordHandler , lNameHandler , fNameHandler , confirmPasswordHandler , emailHandler , ReferCodeHandler , signUpFormik  })=>{
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_11__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_11__/* .getLanguage */ .G)() : "ltr";
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.useTheme)();
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.NoSsr, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
            container: true,
            spacing: 2.5,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: configData?.customer_wallet_status === 1 && configData?.ref_earning_status === 1 ? 6 : 12,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        required: true,
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("User Name"),
                        placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Enter user name"),
                        touched: signUpFormik.touched.name,
                        errors: signUpFormik.errors.name,
                        fieldProps: signUpFormik.getFieldProps("name"),
                        onChangeHandler: fNameHandler,
                        value: signUpFormik.values.name,
                        startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.InputAdornment, {
                            position: "start",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_AccountCircle__WEBPACK_IMPORTED_MODULE_7___default()), {
                                sx: {
                                    color: signUpFormik.touched.name && !signUpFormik.errors.name ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[500], 0.4)
                                }
                            })
                        })
                    })
                }),
                configData?.customer_wallet_status === 1 && configData?.ref_earning_status === 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Refer Code (Optional)"),
                        touched: signUpFormik.touched.ref_code,
                        errors: signUpFormik.errors.ref_code,
                        fieldProps: signUpFormik.getFieldProps("ref_code"),
                        onChangeHandler: ReferCodeHandler,
                        value: signUpFormik.values.ref_code,
                        placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Refer Code"),
                        startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.InputAdornment, {
                            position: "start",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Group__WEBPACK_IMPORTED_MODULE_10___default()), {
                                sx: {
                                    color: signUpFormik.touched.confirm_password && !signUpFormik.errors.confirm_password ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[500], 0.4)
                                }
                            })
                        })
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        required: true,
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Email"),
                        placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Email"),
                        touched: signUpFormik.touched.email,
                        errors: signUpFormik.errors.email,
                        fieldProps: signUpFormik.getFieldProps("email"),
                        onChangeHandler: emailHandler,
                        value: signUpFormik.values.email,
                        startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.InputAdornment, {
                            position: "start",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Mail__WEBPACK_IMPORTED_MODULE_8___default()), {
                                sx: {
                                    color: signUpFormik.touched.email && !signUpFormik.errors.email ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[500], 0.4)
                                }
                            })
                        })
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_custom_component_CustomPhoneInput__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        value: signUpFormik.values.phone,
                        onHandleChange: handleOnChange,
                        initCountry: configData?.country,
                        touched: signUpFormik.touched.phone,
                        errors: signUpFormik.errors.phone,
                        lanDirection: lanDirection,
                        height: "45px",
                        borderRadius: "10px"
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        required: true,
                        type: "password",
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Password"),
                        placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Password"),
                        touched: signUpFormik.touched.password,
                        errors: signUpFormik.errors.password,
                        fieldProps: signUpFormik.getFieldProps("password"),
                        onChangeHandler: passwordHandler,
                        value: signUpFormik.values.password,
                        startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.InputAdornment, {
                            position: "start",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_9___default()), {
                                sx: {
                                    color: signUpFormik.touched.password && !signUpFormik.errors.password ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[500], 0.4)
                                }
                            })
                        })
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Grid, {
                    item: true,
                    xs: 12,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_fields_CustomTextFieldWithFormik__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        required: true,
                        type: "password",
                        label: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Confirm Password"),
                        placeholder: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Confirm Password"),
                        touched: signUpFormik.touched.confirm_password,
                        errors: signUpFormik.errors.confirm_password,
                        fieldProps: signUpFormik.getFieldProps("confirm_password"),
                        onChangeHandler: confirmPasswordHandler,
                        value: signUpFormik.values.confirm_password,
                        startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.InputAdornment, {
                            position: "start",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Lock__WEBPACK_IMPORTED_MODULE_9___default()), {
                                sx: {
                                    color: signUpFormik.touched.confirm_password && !signUpFormik.errors.confirm_password ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[500], 0.4)
                                }
                            })
                        })
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignUpForm);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 49792:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(57987);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_1__]);
react_i18next__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const SignUpValidation = ()=>{
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
    return yup__WEBPACK_IMPORTED_MODULE_0__.object({
        name: yup__WEBPACK_IMPORTED_MODULE_0__.string().required(t("First name is required")),
        email: yup__WEBPACK_IMPORTED_MODULE_0__.string().email(t("Must be a valid email")).max(255).required(t("Email is required")),
        phone: yup__WEBPACK_IMPORTED_MODULE_0__.string().required(t("Please give a phone number")).min(10, "number must be 10 digits"),
        password: yup__WEBPACK_IMPORTED_MODULE_0__.string().required(t("Password is required")).min(6, t("Password is too short - should be 6 chars minimum.")),
        confirm_password: yup__WEBPACK_IMPORTED_MODULE_0__.string().required(t("Confirm Password")).oneOf([
            yup__WEBPACK_IMPORTED_MODULE_0__.ref("password"),
            null
        ], t("Passwords must match"))
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignUpValidation);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 75488:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "aO": () => (/* binding */ ACTIONS),
/* harmony export */   "t": () => (/* binding */ loginReducer),
/* harmony export */   "z6": () => (/* binding */ loginInitialState)
/* harmony export */ });
const loginInitialState = {
    status: "",
    activeLoginType: {
        otp: "",
        manual: "",
        social: ""
    }
};
const loginReducer = (state, action)=>{
    switch(action.type){
        case "setStatus":
            return {
                ...state,
                status: action.payload
            };
        case "setActiveLoginType":
            return {
                ...state,
                activeLoginType: {
                    otp: action.payload.otp,
                    manual: action.payload.manual,
                    social: action.payload.social
                }
            };
        default:
            return state;
    }
};
const ACTIONS = {
    setStatus: "setStatus",
    setActiveLoginType: "setActiveLoginType"
};


/***/ }),

/***/ 40869:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(57987);
/* harmony import */ var _landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77591);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(25452);
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_phone_input_2__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_phone_input_2_lib_style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4463);
/* harmony import */ var react_phone_input_2_lib_style_css__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_phone_input_2_lib_style_css__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_3__]);
react_i18next__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const CustomPhoneNumberInputStyled = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_2__.styled)((react_phone_input_2__WEBPACK_IMPORTED_MODULE_7___default()))(({ theme , languageDirection , borderRadius  })=>({
        "&.react-tel-input .special-label": {
            fontSize: "12px !important",
            fontWeight: "400 !important",
            color: theme.palette.neutral[1000],
            left: languageDirection === "rtl" ? "80%" : "10px",
            backgroundColor: theme.palette.background.paper,
            zIndex: "999",
            display: "inline-block"
        },
        "&.react-tel-input .flag-dropdown": {
            backgroundColor: theme.palette.background.custom2,
            border: `1px solid ${theme.palette.neutral[200]}`,
            borderRadius: borderRadius
        },
        "&.react-tel-input .selected-flag .flag": {
            right: languageDirection === "rtl" && "11px"
        },
        "&.react-tel-input .flag-dropdown.open .selected-flag": {
            backgroundColor: theme.palette.background.default
        },
        "&.react-tel-input .country-list .search-box": {
            backgroundColor: theme.palette.background.custom2,
            color: theme.palette.neutral[600],
            height: "36px !important"
        },
        "&.react-tel-input .country-list .search": {
            backgroundColor: theme.palette.background.custom2
        },
        "&.react-tel-input .selected-flag": {
            backgroundColor: theme.palette.neutral[100],
            borderRadius: "10px 0px 0px 10px !important",
            "&:hover": {
                backgroundColor: theme.palette.background.custom2
            }
        },
        "&.react-tel-input .country-list .country": {
            "&:hover": {
                backgroundColor: theme.palette.background.custom2
            }
        },
        "&.react-tel-input .country-list .search-emoji": {
            marginInlineEnd: "10px",
            display: "none"
        },
        "&.react-tel-input .country-list": {
            backgroundColor: theme.palette.background.custom2,
            [theme.breakpoints.down("sm")]: {
                width: "300px"
            }
        },
        "&.react-tel-input .country-list .country.highlight": {
            backgroundColor: theme.palette.background.default
        },
        "&.react-tel-input .country-list .country-name": {
            color: theme.palette.neutral[1000]
        },
        "&.react-tel-input .country-list .country .dial-code": {
            color: theme.palette.neutral[400]
        },
        "&.react-tel-input .selected-flag .arrow": {
            right: languageDirection === "rtl" ? "-20px" : "25px"
        },
        "&.react-tel-input .form-control": {
            border: `1px solid ${theme.palette.neutral[200]}`,
            backgroundColor: theme.palette.background.paper,
            color: theme.palette.neutral[1000],
            borderRadius: borderRadius ?? "5px",
            paddingLeft: languageDirection === "rtl" ? "48px" : "48px",
            ...languageDirection === "rtl" && {
                textAlign: "left",
                direction: "ltr",
                unicodeBidi: "plaintext"
            },
            "&:-webkit-autofill, &:-webkit-autofill:hover, &:-webkit-autofill:focus": {
                filter: "none",
                WebkitTextFillColor: theme.palette.neutral[1000],
                WebkitBoxShadow: "0 0 0px 40rem " + theme.palette.neutral[200] + " inset"
            }
        },
        "&.react-tel-input .iti__flag-container": {
            left: languageDirection === "rtl" ? "unset" : 0,
            right: languageDirection === "rtl" ? 0 : "unset"
        },
        "&.react-tel-input .iti__selected-flag": {
            left: languageDirection === "rtl" ? 0 : "unset",
            right: languageDirection === "rtl" ? "unset" : 0
        },
        "&.react-tel-input .iti__selected-flag .iti__arrow": {
            transform: languageDirection === "rtl" ? "rotate(180deg)" : "rotate(0deg)"
        }
    }));
const CustomPhoneInputManual = ({ value , onHandleChange , initCountry , touched , errors , lanDirection , height , borderRadius  })=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.useTheme)();
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)((state)=>state.configData);
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const defaultCountry = initCountry?.toLowerCase();
    const changeHandler = (phone)=>{
        onHandleChange(phone);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.NoSsr, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
            alignItems: "flex-start",
            spacing: 0.8,
            children: [
                lanDirection && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomPhoneNumberInputStyled, {
                            borderRadius: borderRadius,
                            autoFormat: false,
                            placeholder: t("Enter phone number"),
                            value: value,
                            enableSearchField: true,
                            enableSearch: true,
                            onChange: changeHandler,
                            inputProps: {
                                required: true,
                                autoFocus: true
                            },
                            specialLabel: t("Phone"),
                            country: defaultCountry,
                            searchStyle: {
                                margin: "0",
                                width: "95%",
                                height: "50px"
                            },
                            inputStyle: {
                                width: "100%",
                                height: height ? height : "56px",
                                borderRadius: borderRadius ? borderRadius : "5px"
                            },
                            languageDirection: lanDirection,
                            buttonClass: {
                                "background-color": "red"
                            },
                            ...configData?.country_picker_status !== 1 && {
                                disableDropdown: true
                            }
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                            style: {
                                backgroundColor: "transparent",
                                position: "absolute",
                                border: `1px solid ${theme.palette.divider}`,
                                borderLeft: "none",
                                borderTopRightRadius: "10px",
                                borderBottomRightRadius: "10px",
                                outline: "none",
                                width: "calc(100% - 52px)",
                                right: 0,
                                top: 0,
                                height: "45px",
                                margin: 0,
                                color: theme.palette.neutral[1000],
                                // opacity: 0,
                                visibility: "hidden"
                            },
                            value: value,
                            onChange: (e)=>changeHandler(e.target.value),
                            autoFocus: true
                        })
                    ]
                }),
                touched && errors && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomTypography */ .ZT, {
                    variant: "caption",
                    sx: {
                        ml: "10px",
                        fontWeight: "inherit",
                        color: (theme)=>theme.palette.error.main
                    },
                    children: errors
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomPhoneInputManual);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 13835:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Xx": () => (/* binding */ appleLoginCredential),
/* harmony export */   "i_": () => (/* binding */ fb_app_id),
/* harmony export */   "q$": () => (/* binding */ google_client_id)
/* harmony export */ });
const google_client_id = "";
const fb_app_id = "";
const appleLoginCredential = {
    serviceId: "",
    redirectURI: ``
};


/***/ })

};
;